/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fryske_akademy.jpa;

/*-
 * #%L
 * ejbCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.fryske_akademy.ejb.CrudReadService;
import org.hibernate.envers.RevisionType;

/**
 * container for revision info for an entity, constructed in {@link CrudReadService#getRevisionInfo(org.fryske_akademy.jpa.EntityInterface, java.lang.Integer, java.lang.Class) }
 * @param <T>
 */
public class RevInfo<T> {

    private final T entity;
    private final RevisionType type;
    private final RevisionInfo revisionInfo;

    public RevInfo(T entity, RevisionType type, RevisionInfo revisionInfo) {
        this.entity = entity;
        this.type = type;
        this.revisionInfo = revisionInfo;
    }

    public T getEntity() {
        return entity;
    }

    public RevisionType getType() {
        return type;
    }

    public RevisionInfo getRevisionInfo() {
        return revisionInfo;
    }
    
}
