/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.TypedQuery;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.JpqlBuilder;
import org.fryske_akademy.ejb.Param;

@Stateless
@Local(value={JpqlBuilder.class})
public class JpqlBuilderImpl
implements JpqlBuilder {
    private static final Logger LOGGER = Logger.getLogger(JpqlBuilder.class.getName());
    public static final String TABLE_ALIAS = "e";

    @Override
    public String orderClause(Map<String, CrudReadService.SORTORDER> sort) {
        if (sort != null && !sort.isEmpty()) {
            String srt = "";
            boolean first = true;
            for (Map.Entry<String, CrudReadService.SORTORDER> entry : sort.entrySet()) {
                String sortField = entry.getKey();
                if (sortField == null) continue;
                srt = srt + (first ? " order by" : ",");
                srt = srt + " e." + sortField + " " + entry.getValue();
                first = false;
            }
            return srt;
        }
        return "";
    }

    @Override
    public String whereClause(List<Param> params) {
        if (params != null && !params.isEmpty()) {
            String where = "";
            boolean first = true;
            for (Param param : params) {
                where = where + (first ? " where" : param.getAndOr()) + this.whereCondition(param);
                first = false;
            }
            return where;
        }
        return "";
    }

    @Override
    public String whereCondition(Param param) {
        if (param.getOperator().toLowerCase().contains("member of")) {
            return " :" + param.getParamKey() + param.getNot() + param.getOperator() + " e." + param.getPropertyPath();
        }
        if (param.getOperator().toLowerCase().contains("in")) {
            return " e." + param.getPropertyPath() + param.getNot() + param.getOperator() + "( :" + param.getParamKey() + " )";
        }
        if (param.getOperator().toLowerCase().contains("null") || param.getOperator().toLowerCase().contains("empty")) {
            return " e." + param.getPropertyPath() + param.getOperator();
        }
        return param.getNot() + " e." + param.getPropertyPath() + param.getOperator() + ":" + param.getParamKey();
    }

    @Override
    public void setWhereParams(TypedQuery q, List<Param> params) {
        if (params != null && !params.isEmpty()) {
            for (Param param : params) {
                this.setParam(q, param);
            }
        }
    }

    @Override
    public void setParam(TypedQuery q, Param param) {
        if (param.isSkipSetValue()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("skipping " + param);
            }
            return;
        }
        if (Short.class.isAssignableFrom(q.getParameter(param.getParamKey()).getParameterType()) && param.getParamValue() instanceof String) {
            q.setParameter(param.getParamKey(), (Object)Short.valueOf(String.valueOf(param.getParamValue())));
        } else if (Integer.class.isAssignableFrom(q.getParameter(param.getParamKey()).getParameterType()) && param.getParamValue() instanceof String) {
            q.setParameter(param.getParamKey(), (Object)Integer.valueOf(String.valueOf(param.getParamValue())));
        } else {
            q.setParameter(param.getParamKey(), (Object)param.getParamValue());
        }
    }
}

