/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Param
implements Serializable {
    private final String propertyPath;
    private final String paramKey;
    private final String operator;
    private final Serializable paramValue;
    private final String not;
    private final AndOr andOr;
    private final boolean skipSetValue;

    private Param(String propertyPath, String paramKey, String operator, Serializable paramValue, boolean not, boolean or) {
        this.propertyPath = propertyPath + " ";
        this.skipSetValue = Builder.nullComp(operator) || Builder.emptyComp(operator);
        this.paramKey = paramKey;
        this.operator = " " + operator + " ";
        this.paramValue = paramValue;
        this.not = not ? " NOT " : " ";
        this.andOr = AndOr.fromBool(or);
    }

    private Param(String propertyPath, String paramKey, String operator, Serializable paramValue) {
        this(propertyPath, paramKey, operator, paramValue, false, false);
    }

    private Param(String paramKey, Serializable paramValue) {
        this(paramKey, paramKey, "=", paramValue, false, false);
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public String getOperator() {
        return this.operator;
    }

    public Serializable getParamValue() {
        return this.paramValue;
    }

    public String getNot() {
        return this.not;
    }

    public AndOr getAndOr() {
        return this.andOr;
    }

    public boolean isSkipSetValue() {
        return this.skipSetValue;
    }

    public String toString() {
        return "Param{propertyPath=" + this.propertyPath + ", paramKey=" + this.paramKey + ", operator=" + this.operator + ", paramValue=" + this.paramValue + ", not=" + this.not + ", andOr=" + (Object)((Object)this.andOr) + ", skipSetValue=" + this.skipSetValue + '}';
    }

    public static class Builder {
        private final List<Param> params = new ArrayList<Param>(3);
        public static final String ISNULL = "is null";
        public static final String ISNOTNULL = "is not null";
        public static final String ISEMPTY = "is empty";
        public static final String ISNOTEMPTY = "is not empty";
        public static final char NEGATION = '!';
        private final boolean syntaxInValue;

        public Builder(boolean syntaxInValue) {
            this.syntaxInValue = syntaxInValue;
        }

        public Builder() {
            this(true);
        }

        public Builder add(String propertyPath, String paramKey, String operator, Object paramValue) {
            if (paramValue instanceof String) {
                return this.add(propertyPath, paramKey, operator, String.valueOf(paramValue), false);
            }
            return this.add(propertyPath, paramKey, operator, paramValue, false, false);
        }

        public Builder add(String propertyPath, String paramKey, String operator, String paramValue, boolean or) {
            return this.add(propertyPath, paramKey, this.determineOperator(operator, paramValue), this.stripNegation(paramValue), this.isNegation(paramValue), or);
        }

        public Builder add(String propertyPath, String paramKey, String operator, Object paramValue, boolean not, boolean or) {
            this.params.add(new Param(propertyPath, paramKey, operator, (Serializable)paramValue, not, or));
            return this;
        }

        public boolean isNegation(String value) {
            return this.syntaxInValue && value != null && value.indexOf(33) == 0;
        }

        private String stripNegation(String value) {
            return this.isNegation(value) ? value.substring(1) : value;
        }

        private String determineOperator(String operator, String value) {
            if (this.syntaxInValue && Builder.nullComp(value)) {
                return value;
            }
            return operator;
        }

        public static boolean nullComp(String s) {
            if (s == null) {
                return false;
            }
            String t = s.trim().toLowerCase();
            return t.equals(ISNULL) || t.equals(ISNOTNULL);
        }

        public static boolean emptyComp(String s) {
            if (s == null) {
                return false;
            }
            String t = s.trim().toLowerCase();
            return t.equals(ISEMPTY) || t.equals(ISNOTEMPTY);
        }

        public Builder add(String paramKey, Object paramValue) {
            return this.add(paramKey, paramValue, false);
        }

        public Builder add(String paramKey, Object paramValue, boolean or) {
            if (paramValue instanceof String) {
                return this.add(paramKey, paramKey, "like", (String)paramValue, or);
            }
            return this.add(paramKey, paramKey, "=", paramValue, false, or);
        }

        public List<Param> build() {
            return this.params;
        }

        public boolean isSyntaxInValue() {
            return this.syntaxInValue;
        }
    }

    public static enum AndOr {
        AND,
        OR;


        private static AndOr fromBool(boolean or) {
            return or ? OR : AND;
        }

        public String toString() {
            return " " + this.name() + " ";
        }
    }
}

