/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.CrudWriteService;
import org.fryske_akademy.ejb.JpqlBuilder;
import org.fryske_akademy.ejb.Param;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jpa.RevisionInfo;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.IdentifierEqAuditExpression;

@DeclareRoles(value={"editor"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public abstract class AbstractCrudService
implements CrudReadService,
CrudWriteService {
    @EJB
    private JpqlBuilder jpqlBuilder;
    private static final Logger LOGGER = Logger.getLogger(AbstractCrudService.class.getName());
    public static final int DEFAULT_PAGE_SIZE = 30;
    public static final String EDITOR = "editor";

    protected abstract EntityManager getEntityManager();

    @Override
    public <T extends EntityInterface> T find(Serializable id, Class<T> type) {
        return (T)((EntityInterface)this.getEntityManager().find(type, (Object)id));
    }

    @Override
    public <T extends EntityInterface> List<T> findAll(Class<T> type) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(type));
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    @Override
    public <T extends EntityInterface> List<T> findDynamic(Integer first, Integer pageSize, Map<String, CrudReadService.SORTORDER> sort, List<Param> params, Class<T> type) {
        String jpql = "from " + type.getSimpleName() + " e" + this.jpqlBuilder.whereClause(params) + this.jpqlBuilder.orderClause(sort);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(jpql);
        }
        TypedQuery q = this.getEntityManager().createQuery(jpql, type);
        this.jpqlBuilder.setWhereParams((Query)q, params);
        q.setFirstResult(first == null ? 0 : first);
        if (pageSize >= 0) {
            q.setMaxResults(pageSize == null ? 30 : pageSize);
        }
        return q.getResultList();
    }

    @Override
    public int countDynamic(List<Param> params, Class type) {
        String jpql = "select count(*) from " + type.getSimpleName() + " e" + this.jpqlBuilder.whereClause(params);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(jpql);
        }
        return this.doCount((Query)this.getEntityManager().createQuery(jpql, Long.class), params);
    }

    @Override
    public <T extends EntityInterface> List<T> find(String namedQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doFind((Query)this.getEntityManager().createNamedQuery(namedQuery, type), params, first, max);
    }

    @Override
    public <T extends EntityInterface> List<T> findNative(String namedNativeQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doFind(this.getEntityManager().createNamedQuery(namedNativeQuery), params, first, max);
    }

    @Override
    public int count(String namedQuery, List<Param> params) {
        return this.doCount(this.getEntityManager().createNamedQuery(namedQuery), params);
    }

    @Override
    public <T extends EntityInterface> T findOne(String namedQuery, List<Param> params, Class<T> type) {
        TypedQuery q = this.getEntityManager().createNamedQuery(namedQuery, type);
        this.jpqlBuilder.setWhereParams((Query)q, params);
        try {
            return (T)((EntityInterface)q.getSingleResult());
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public <T extends EntityInterface> T getRevision(Number n, Class<T> type) {
        if (!type.isAnnotationPresent(Audited.class)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No @Audited annotation on " + type.getName());
            }
            return null;
        }
        return (T)((EntityInterface)AuditReaderFactory.get((EntityManager)this.getEntityManager()).createQuery().forEntitiesAtRevision(type, n).getSingleResult());
    }

    @Override
    public <T extends EntityInterface> List<RevInfo<T>> getRevisionInfo(T entity, Integer max, Class<T> type) {
        ArrayList<RevInfo<T>> result = new ArrayList<RevInfo<T>>(5);
        if (!type.isAnnotationPresent(Audited.class)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No @Audited annotation on " + type.getName());
            }
            return result;
        }
        if (entity == null) {
            return result;
        }
        AuditQuery query = AuditReaderFactory.get((EntityManager)this.getEntityManager()).createQuery().forRevisionsOfEntity(type, false, true).addOrder(AuditEntity.revisionNumber().desc());
        query.add((AuditCriterion)new IdentifierEqAuditExpression(null, (Object)entity.getId(), true)).setMaxResults(max == null ? 5 : max);
        List resultList = query.getResultList();
        if (resultList.isEmpty()) {
            return result;
        }
        for (Object[] object : resultList) {
            result.add(new RevInfo<EntityInterface>((EntityInterface)object[0], (RevisionType)object[2], (RevisionInfo)((Object)object[1])));
        }
        return result;
    }

    @Override
    @RolesAllowed(value={"editor"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public <T extends EntityInterface> T createOrUpdate(T t) {
        if (t.isTransient()) {
            this.getEntityManager().persist(t);
            return t;
        }
        return (T)((EntityInterface)this.getEntityManager().merge(t));
    }

    @Override
    @RolesAllowed(value={"editor"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void delete(EntityInterface t) {
        this.getEntityManager().remove(this.getEntityManager().merge((Object)t));
    }

    @Override
    public <T extends EntityInterface> List<Number> getRevisionNumbers(Object id, Class<T> type) {
        if (!type.isAnnotationPresent(Audited.class)) {
            return Collections.emptyList();
        }
        return AuditReaderFactory.get((EntityManager)this.getEntityManager()).getRevisions(type, id);
    }

    private List doFind(Query q, List<Param> params, Integer first, Integer max) {
        this.jpqlBuilder.setWhereParams(q, params);
        q.setFirstResult(first == null ? 0 : first);
        if (max >= 0) {
            q.setMaxResults(max == null ? 30 : max);
        }
        return q.getResultList();
    }

    private int doCount(Query q, List<Param> params) {
        this.jpqlBuilder.setWhereParams(q, params);
        return Integer.valueOf(String.valueOf(q.getSingleResult()));
    }
}

