/*
 * Copyright 2018 Fryske Akademy.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fryske_akademy.ejb;

import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 *
 * @author eduard
 */
public class EJBHelper {
    
    /**
     * When injection fails, you can lookup a bean, this method helps by constructing a portable jndi lookup string and performing
     * the lookup in the InitialContext. Calls {@link #lookUpBean(java.lang.Class, java.lang.String, java.lang.String, java.lang.String) }
     * with beanClass.getName().
     * @param <T>
     * @param interfaceClass the interface for which you want a bean
     * @param beanClass the bean class you want to use
     * @param artifactId
     * @param version
     * @return
     * @throws NamingException 
     */
    public static <T> T lookUpBean(Class<T> interfaceClass, Class beanClass, String artifactId, String version) throws NamingException {
        return lookUpBean(interfaceClass, beanClass.getName(), artifactId, version);
    }

    public static <T> T lookUpBean(Class<T> interfaceClass, String beanClassName, String artifactId, String version) throws NamingException {
        InitialContext initialContext = new InitialContext();
        return (T)initialContext.lookup("java:global/" + artifactId + "-" + version + "/"+beanClassName+"!" + interfaceClass.getName());
    }
    
}
