/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.JpqlBuilder;
import org.fryske_akademy.ejb.Param;

@Stateless
@Local(value={JpqlBuilder.class})
public class JpqlBuilderImpl
implements JpqlBuilder {
    private static final Logger LOGGER = Logger.getLogger(JpqlBuilder.class.getName());
    public static final String TABLE_ALIAS = "e";

    @Override
    public String orderClause(Map<String, CrudReadService.SORTORDER> sort) {
        if (sort != null && !sort.isEmpty()) {
            String srt = "";
            boolean first = true;
            for (Map.Entry<String, CrudReadService.SORTORDER> entry : sort.entrySet()) {
                String sortField = entry.getKey();
                if (sortField == null) continue;
                srt = srt + (first ? " order by" : ",");
                srt = srt + " e." + sortField + " " + entry.getValue();
                first = false;
            }
            return srt;
        }
        return "";
    }

    @Override
    public String whereClause(List<Param> params) {
        if (params != null && !params.isEmpty()) {
            String where = "";
            boolean first = true;
            for (Param param : params) {
                where = where + (first ? " where" : param.getAndOr()) + this.whereCondition(param);
                first = false;
            }
            return where;
        }
        return "";
    }

    @Override
    public String whereCondition(Param param) {
        if (param.getOperator().toLowerCase().contains("member of")) {
            if (param.getParamValue() instanceof Collection) {
                if (!((Collection)param.getParamValue()).isEmpty()) {
                    StringBuilder rv = new StringBuilder(" (");
                    AtomicBoolean first = new AtomicBoolean(true);
                    AtomicInteger i = new AtomicInteger();
                    ((Collection)param.getParamValue()).forEach(t -> {
                        if (first.get()) {
                            first.set(false);
                        } else {
                            rv.append(" or ");
                        }
                        rv.append(":" + param.getParamKey() + i.getAndIncrement() + param.getNot() + param.getOperator() + " e." + param.getPropertyPath());
                    });
                    return rv.append(')').toString();
                }
                return "";
            }
            return " :" + param.getParamKey() + param.getNot() + param.getOperator() + " e." + param.getPropertyPath();
        }
        if (param.getOperator().toLowerCase().contains("in")) {
            return " e." + param.getPropertyPath() + param.getNot() + param.getOperator() + "( :" + param.getParamKey() + " )";
        }
        if (param.getOperator().toLowerCase().contains("null") || param.getOperator().toLowerCase().contains("empty")) {
            return " e." + param.getPropertyPath() + param.getOperator();
        }
        return param.getNot() + " e." + param.getPropertyPath() + param.getOperator() + ":" + param.getParamKey();
    }

    @Override
    public void setWhereParams(Query q, List<Param> params) {
        if (params != null && !params.isEmpty()) {
            for (Param param : params) {
                this.setParam(q, param);
            }
        }
    }

    protected void set(Query q, String key, Object value) {
        if (q instanceof TypedQuery) {
            q.setParameter(key, value);
        } else {
            q.setParameter((int)Short.valueOf(key).shortValue(), value);
        }
    }

    @Override
    public void setParam(Query q, Param param) {
        boolean hasParam = false;
        try {
            q.getParameter(param.getParamKey());
            hasParam = true;
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        if (param.isSkipSetValue() && !hasParam) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("skipping " + param);
            }
            return;
        }
        if (param.isSkipSetValue() && hasParam && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Param indicates skipping but query contains it, skipping is ignored: " + param);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("trying to set: " + param);
        }
        Class pt = null;
        if (param.getOperator().toLowerCase().contains("member of") && param.getParamValue() instanceof Collection) {
            pt = Collection.class;
        } else {
            try {
                pt = q.getParameter(param.getParamKey()).getParameterType() != null ? q.getParameter(param.getParamKey()).getParameterType() : param.getParamType();
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                pt = param.getParamType();
            }
        }
        if (Short.class.isAssignableFrom(pt) && param.getParamValue() instanceof String) {
            this.set(q, param.getParamKey(), Short.valueOf(String.valueOf(param.getParamValue())));
        } else if (Integer.class.isAssignableFrom(pt) && param.getParamValue() instanceof String) {
            this.set(q, param.getParamKey(), Integer.valueOf(String.valueOf(param.getParamValue())));
        } else if (param.getOperator().toLowerCase().contains("member of") && param.getParamValue() instanceof Collection) {
            AtomicInteger i = new AtomicInteger();
            ((Collection)param.getParamValue()).forEach(t -> this.set(q, param.getParamKey() + i.getAndIncrement(), t));
        } else {
            if (param.getParamValue() instanceof Collection && !param.getOperator().toLowerCase().contains("in") && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("value for " + param.getParamKey() + " is a collection, you may want to use the \"in\" operator");
            }
            this.set(q, param.getParamKey(), param.getParamValue());
        }
    }
}

