package org.fryske_akademy.jpa;

/*-
 * #%L
 * ejbCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class JpaUtil { 
    
    private static final Logger LOGGER = Logger.getLogger(JpaUtil.class.getName());
    private static final Map<String, EntityManagerFactory> factories = new ConcurrentHashMap<>(1);

    public static EntityManagerFactory getFactory(String name) {
        if (!factories.containsKey(name)) {
            factories.put(name, Persistence.createEntityManagerFactory(name));
        }
        return factories.get(name);
    }

    /**
     * 
     * @return
     * @throws javax.naming.NamingException
     * @throws IllegalStateException 
     */
    public static Principal findPrincipal() throws NamingException, IllegalStateException {
        Principal p = null;
        try {
            p = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        } catch (IllegalStateException e) {
            LOGGER.warning("failure finding principal in facescontext, trying ejbcontext");
        }
        if (p == null) {
            InitialContext ic = new InitialContext();
            SessionContext context = (SessionContext) ic.lookup("java:comp/EJBContext");
            p = context.getCallerPrincipal();
        }
        return p;
    }
    
}
