/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.EJBException;

public class Util {
    public static <T> T setEnumsFromString(String inputString, T objectWithEnums) {
        new Scanner(inputString).forEachRemaining(t -> {
            boolean set = false;
            if (inputString.indexOf(".") > 0) {
                String enumName = t.substring(0, t.indexOf(46));
                String enumValue = t.substring(t.indexOf(46) + 1);
                for (Method m : objectWithEnums.getClass().getMethods()) {
                    if (!m.getName().equalsIgnoreCase("set" + enumName)) continue;
                    Class<?> clazz = m.getParameterTypes()[0];
                    for (Enum e : (Enum[])clazz.getEnumConstants()) {
                        if (!e.name().equalsIgnoreCase(enumValue)) continue;
                        try {
                            m.invoke(objectWithEnums, e);
                            set = true;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                            throw new EJBException(ex);
                        }
                    }
                }
            }
            if (!set) {
                throw new IllegalArgumentException(t + " not found in " + objectWithEnums);
            }
        });
        return objectWithEnums;
    }

    public static boolean hasSetterForEnumString(String t, Object objectWithEnums) {
        if (t.indexOf(".") > 0) {
            String enumName = t.substring(0, t.indexOf(46));
            String enumValue = t.substring(t.indexOf(46) + 1);
            for (Method m : objectWithEnums.getClass().getMethods()) {
                if (!m.getName().equalsIgnoreCase("set" + enumName)) continue;
                Class<?> clazz = m.getParameterTypes()[0];
                for (Enum e : (Enum[])clazz.getEnumConstants()) {
                    if (!e.name().equalsIgnoreCase(enumValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> T setEnum(Enum e, T objectWithEnums) {
        for (Method m : objectWithEnums.getClass().getMethods()) {
            if (!m.getName().equals("set" + e.getClass().getSimpleName())) continue;
            try {
                m.invoke(objectWithEnums, e);
                return objectWithEnums;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new EJBException(ex);
            }
        }
        throw new IllegalArgumentException(e + " not found in " + objectWithEnums);
    }

    public static Enum getEnumWithValue(Object objectWithEnums) {
        for (Method m : objectWithEnums.getClass().getMethods()) {
            if (!m.getReturnType().isEnum() || m.getParameterCount() != 0) continue;
            try {
                Object o = m.invoke(objectWithEnums, new Object[0]);
                if (o == null) continue;
                return (Enum)o;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new EJBException(ex);
            }
        }
        return null;
    }

    public static List<Enum> listEnums(Class clazz) {
        ArrayList<Enum> rv = new ArrayList<Enum>(100);
        for (Method m : clazz.getMethods()) {
            Class<?> c = m.getReturnType();
            if (!c.isEnum()) continue;
            Enum[] e = (Enum[])c.getEnumConstants();
            rv.addAll(Arrays.asList(e));
        }
        return rv;
    }

    public static Enum findInClass(Class clazz, String e) {
        if (e.indexOf(".") > 0) {
            for (Method m : clazz.getMethods()) {
                Class<?> c;
                if (!m.getReturnType().isEnum() || m.getParameterCount() != 0 || !(c = m.getReturnType()).getSimpleName().equalsIgnoreCase(e.substring(0, e.indexOf(".")))) continue;
                for (Enum en : (Enum[])c.getEnumConstants()) {
                    if (!en.name().equalsIgnoreCase(e.substring(e.indexOf(".") + 1))) continue;
                    return en;
                }
            }
        }
        return null;
    }

    public static String toString(Enum e) {
        return e.getClass().getSimpleName() + '.' + e.name();
    }

    public static String toString(List<Enum> l) {
        StringBuilder sb = new StringBuilder().append('[');
        AtomicBoolean first = new AtomicBoolean(true);
        l.forEach(e -> {
            if (first.get()) {
                first.set(false);
                sb.append(Util.toString(e));
            } else {
                sb.append(", ").append(e.getClass().getSimpleName()).append('.').append(e.name());
            }
        });
        return sb.append(']').toString();
    }

    public static String split(String toSplit, int index) {
        return Util.split(toSplit, index, false);
    }

    public static String split(String toSplit, int index, boolean ignorePatternAfterIndex) {
        return Util.split(toSplit, ": ?", index, ignorePatternAfterIndex);
    }

    public static String split(String toSplit, String regex, int index, boolean ignorePatternAfterIndex) {
        if (toSplit == null) {
            return toSplit;
        }
        String[] split = toSplit.split(regex, ignorePatternAfterIndex ? index + 1 : -1);
        return index < split.length ? split[index] : null;
    }
}

