/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import javax.transaction.Transactional;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.CrudWriteService;
import org.fryske_akademy.ejb.JpqlBuilder;
import org.fryske_akademy.ejb.JpqlBuilderImpl;
import org.fryske_akademy.ejb.Param;

@DeclareRoles(value={"editor"})
public abstract class AbstractCrudService
implements CrudReadService,
CrudWriteService {
    private static final JpqlBuilder jpqlBuilder = new JpqlBuilderImpl();
    private static final Logger LOGGER = Logger.getLogger(AbstractCrudService.class.getName());
    public static final int DEFAULT_PAGE_SIZE = 30;
    public static final String EDITORROLE = "editor";

    protected abstract EntityManager getEntityManager();

    @Override
    public <T extends Serializable> T find(Serializable id, Class<T> type) {
        return (T)((Serializable)this.getEntityManager().find(type, (Object)id));
    }

    @Override
    public <T extends Serializable> List<T> findAll(Class<T> type) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(type));
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    @Override
    public <T extends Serializable> List<T> findDynamic(Integer first, Integer pageSize, Map<String, CrudReadService.SORTORDER> sort, List<Param> params, Class<T> type) {
        String jpql = "from " + type.getSimpleName() + " e" + jpqlBuilder.whereClause(params) + jpqlBuilder.orderClause(sort);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(jpql);
        }
        TypedQuery q = this.getEntityManager().createQuery(jpql, type);
        jpqlBuilder.setWhereParams((Query)q, params);
        q.setFirstResult(first == null ? 0 : first);
        if (pageSize == null || pageSize >= 0) {
            q.setMaxResults(pageSize == null ? 30 : pageSize);
        }
        return q.getResultList();
    }

    @Override
    public int countDynamic(List<Param> params, Class type) {
        String jpql = "select count(*) from " + type.getSimpleName() + " e" + jpqlBuilder.whereClause(params);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(jpql);
        }
        return this.doCount((Query)this.getEntityManager().createQuery(jpql, Long.class), params);
    }

    @Override
    public <T extends Serializable> List<T> find(String namedQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doFind((Query)this.getEntityManager().createNamedQuery(namedQuery, type), params, first, max);
    }

    @Override
    public <T extends Serializable> List<T> findNative(String namedNativeQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doFind(this.getEntityManager().createNamedQuery(namedNativeQuery), params, first, max);
    }

    @Override
    public int count(String namedQuery, List<Param> params) {
        return this.doCount(this.getEntityManager().createNamedQuery(namedQuery), params);
    }

    @Override
    public <T extends Serializable> T findOne(String namedQuery, List<Param> params, Class<T> type) {
        TypedQuery q = this.getEntityManager().createNamedQuery(namedQuery, type);
        jpqlBuilder.setWhereParams((Query)q, params);
        try {
            return (T)((Serializable)q.getSingleResult());
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T extends Serializable> T create(T t) {
        this.getEntityManager().persist(t);
        return t;
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T extends Serializable> T update(T t) {
        return (T)((Serializable)this.getEntityManager().merge(t));
    }

    @Override
    @Transactional
    @TransactionAttribute
    @RolesAllowed(value={"editor"})
    public void delete(Serializable t) {
        this.getEntityManager().remove(this.getEntityManager().merge((Object)t));
    }

    private List doFind(Query q, List<Param> params, Integer first, Integer max) {
        jpqlBuilder.setWhereParams(q, params);
        q.setFirstResult(first == null ? 0 : first);
        if (max != null) {
            if (max >= 0) {
                q.setMaxResults(max.intValue());
            }
        } else {
            q.setMaxResults(30);
        }
        return q.getResultList();
    }

    private int doCount(Query q, List<Param> params) {
        jpqlBuilder.setWhereParams(q, params);
        return Integer.parseInt(String.valueOf(q.getSingleResult()));
    }
}

