/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fryske_akademy.ejb;

/*-
 * #%L
 * ejbCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Generic interface for read operations on entities.
 *
 * @see SORTORDER
 * @see Param
 * @author eduard
 */
public interface CrudReadService {

    public enum SORTORDER implements Serializable {
        DESC, ASC;
        
        public static Map<String, SORTORDER> order(String key, SORTORDER order) {
            return new Builder().add(key, order).build();
        }

        public static class Builder {

            private final Map<String, SORTORDER> sort = new HashMap<>(2);

            public Builder add(String key, SORTORDER o) {
                sort.put(key, o);
                return this;
            }

            public Map<String, SORTORDER> build() {
                return sort;
            }
        }
    }

    public <T extends Serializable> T find(Serializable id, Class<T> type);

    public <T extends Serializable> List<T> findAll(Class<T> type);

    /**
     * 
     * @param <T>
     * @param first
     * @param pageSize
     * @param sort
     * @param params
     * @param type
     * @return 
     */
    public <T extends Serializable> List<T> findDynamic(Integer first, Integer pageSize, Map<String, SORTORDER> sort, List<Param> params, Class<T> type);

    public int countDynamic(List<Param> params, Class type);

    public <T extends Serializable> List<T> find(String namedQuery, List<Param> params, Integer first, Integer max, Class<T> type);

    public <T extends Serializable> List<T> findNative(String namedNativeQuery, List<Param> params, Integer first, Integer max, Class<T> type);

    /**
     * Use in conjunction with {@link #find(java.lang.String, java.util.List, java.lang.Integer, java.lang.Integer, java.lang.Class) } or
     * {@link #findNative(java.lang.String, java.util.List, java.lang.Integer, java.lang.Integer, java.lang.Class) }.
     * @param namedQuery
     * @param params
     * @return 
     */
    public int count(String namedQuery, List<Param> params);

    /**
     * return one result or null, multiple results throws an exception
     * @param <T>
     * @param namedQuery
     * @param params
     * @param type
     * @return 
     */
    public <T extends Serializable> T findOne(String namedQuery, List<Param> params, Class<T> type);

}
