/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.util.ArrayList;
import java.util.List;

public class Param {
    private final String propertyPath;
    private final String paramKey;
    private final String operator;
    private final Object paramValue;
    private final String not;
    private final AndOr andOr;
    private final boolean skipSetValue;
    private final Class paramType;

    public static List<Param> one(String key, Object value) {
        return Param.one(key, value, true, Builder.DEFAULT_MAPPING);
    }

    public static List<Param> one(String key, Object value, boolean syntaxSupport, Builder.WildcardMapping wildcardMapping) {
        return new Builder(syntaxSupport, wildcardMapping).add(key, value).build();
    }

    private Param(String propertyPath, String paramKey, String operator, Object paramValue, boolean not, boolean or) {
        this.propertyPath = propertyPath + " ";
        this.skipSetValue = Builder.nullComp(operator) || Builder.emptyComp(operator);
        this.paramKey = paramKey;
        this.operator = " " + operator + " ";
        this.paramValue = paramValue;
        this.not = not ? " NOT " : " ";
        this.andOr = AndOr.fromBool(or);
        this.paramType = paramValue == null ? Object.class : paramValue.getClass();
    }

    private Param(String propertyPath, String paramKey, String operator, Object paramValue) {
        this(propertyPath, paramKey, operator, paramValue, false, false);
    }

    private Param(String paramKey, Object paramValue) {
        this(paramKey, paramKey, "=", paramValue, false, false);
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public String getOperator() {
        return this.operator;
    }

    public Object getParamValue() {
        return this.paramValue;
    }

    public String getNot() {
        return this.not;
    }

    public AndOr getAndOr() {
        return this.andOr;
    }

    public boolean isSkipSetValue() {
        return this.skipSetValue;
    }

    public Class getParamType() {
        return this.paramType;
    }

    public String toString() {
        return "Param{propertyPath=" + this.propertyPath + ", paramKey=" + this.paramKey + ", operator=" + this.operator + ", paramValue=" + this.paramValue + ", not=" + this.not + ", andOr=" + (Object)((Object)this.andOr) + ", skipSetValue=" + this.skipSetValue + '}';
    }

    public static class Builder {
        private final List<Param> params = new ArrayList<Param>(3);
        public static final WildcardMapping DEFAULT_MAPPING = new DefaultWildcardMapping();
        public static final String ISNULL = "is null";
        public static final String ISNOTNULL = "is not null";
        public static final String ISEMPTY = "is empty";
        public static final String ISNOTEMPTY = "is not empty";
        public static final char NEGATION = '!';
        private final boolean syntaxInValue;
        private final WildcardMapping wildcardMapping;

        public Builder(boolean syntaxInValue, WildcardMapping wildcardMapping) {
            this.syntaxInValue = syntaxInValue;
            this.wildcardMapping = wildcardMapping;
        }

        public Builder() {
            this(true, null);
        }

        public Builder add(String propertyPath, String paramKey, String operator, Object paramValue) {
            if (paramValue instanceof String) {
                return this.add(propertyPath, paramKey, operator, String.valueOf(paramValue), false);
            }
            return this.add(propertyPath, paramKey, operator, paramValue, false, false);
        }

        public Builder add(String propertyPath, String paramKey, String operator, String paramValue, boolean or) {
            return this.add(propertyPath, paramKey, this.determineOperator(operator, paramValue), this.replaceWildcards(this.stripNegation(paramValue)), this.isNegation(paramValue), or);
        }

        public Builder add(String propertyPath, String paramKey, String operator, Object paramValue, boolean not, boolean or) {
            this.params.add(new Param(propertyPath, paramKey, operator, paramValue, not, or));
            return this;
        }

        public boolean isNegation(String value) {
            return this.syntaxInValue && value != null && value.indexOf(33) == 0;
        }

        private String stripNegation(String value) {
            return this.isNegation(value) ? value.substring(1) : value;
        }

        private String replaceWildcards(String value) {
            return this.wildcardMapping == null ? value : value.replace(this.wildcardMapping.getMoreIn(), this.wildcardMapping.getMoreOut()).replace(this.wildcardMapping.getOneIn(), this.wildcardMapping.getOneOut());
        }

        private String determineOperator(String operator, String value) {
            if (this.syntaxInValue && Builder.nullComp(value)) {
                return value;
            }
            return operator;
        }

        public static boolean nullComp(String s) {
            if (s == null) {
                return false;
            }
            String t = s.trim().toLowerCase();
            return t.equals(ISNULL) || t.equals(ISNOTNULL);
        }

        public static boolean emptyComp(String s) {
            if (s == null) {
                return false;
            }
            String t = s.trim().toLowerCase();
            return t.equals(ISEMPTY) || t.equals(ISNOTEMPTY);
        }

        public Builder add(String paramKey, Object paramValue) {
            return this.add(paramKey, paramValue, false);
        }

        public Builder add(String paramKey, Object paramValue, boolean or) {
            if (paramValue instanceof String) {
                return this.add(paramKey, paramKey, "like", (String)paramValue, or);
            }
            return this.add(paramKey, paramKey, "=", paramValue, false, or);
        }

        public List<Param> build() {
            return this.params;
        }

        public boolean isSyntaxInValue() {
            return this.syntaxInValue;
        }

        public boolean containsKey(String key) {
            return this.params.stream().anyMatch(t -> t.getParamKey().equals(key));
        }

        public static class DefaultWildcardMapping
        implements WildcardMapping {
            @Override
            public char getMoreIn() {
                return '*';
            }

            @Override
            public char getMoreOut() {
                return '%';
            }

            @Override
            public char getOneIn() {
                return '?';
            }

            @Override
            public char getOneOut() {
                return '_';
            }
        }

        public static interface WildcardMapping {
            public char getMoreIn();

            public char getMoreOut();

            public char getOneIn();

            public char getOneOut();
        }
    }

    public static enum AndOr {
        AND,
        OR;


        private static AndOr fromBool(boolean or) {
            return or ? OR : AND;
        }

        public String toString() {
            return " " + this.name() + " ";
        }
    }
}

