/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fryske_akademy.ejb;

/*-
 * #%L
 * ejbCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.io.Serializable;
import java.util.Collection;
import org.fryske_akademy.jpa.AbstractEntity;

/**
 * Generic interface for write operations on entities
 * @author eduard
 */
public interface CrudWriteService extends CrudReadService {

    public <T extends Serializable> T create(T t);
    
    public <T extends Serializable> T update(T t);

    /**
     * create or update depending on {@link AbstractEntity#isTransient() }.
     * @param <T>
     * @param t
     * @return 
     */
    public <T extends AbstractEntity> T save(T t);

    public void delete(Serializable t);
    
    /**
     * create multiple entities
     * @param entities
     * @param flushCount when not null try to optimize (flush/clear) every so many entities
     * @return number of entities created
     */
    public int batchCreate(Collection<? extends Serializable> entities, Integer flushCount);
    
    /**
     * update multiple entities
     * @param entities
     * @param flushCount when not null try to optimize (flush/clear) every so many entities
     * @return number of entities updated
     */
    public int batchUpdate(Collection<? extends Serializable> entities, Integer flushCount);

    /**
     * delete multiple entities
     * @param entities
     * @param flushCount when not null try to optimize (flush/clear) every so many entities
     * @return number of entities deleted
     */
    public int batchDelete(Collection<? extends Serializable> entities, Integer flushCount);
    
}
