/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.exist.jobs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.EnumSet;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.FileInputSource;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataSyncTask
implements SystemTask {
    private static final Logger LOG = LogManager.getLogger(DataSyncTask.class);
    public static final String DATA_DIR = "/data";
    public static final String COLLECTION_PARAM = "collection";
    public static final String DATADIR_PARAM = "datadir";
    public static final String REMOVE_FROM_COLLECTION_PARAM = "removeNotInSource";
    public static final String CLEAR_CACHE_XQ = "xquery version \"3.1\";\nimport module namespace cache = \"http://exist-db.org/xquery/cache\";\ncache:clear()";
    public static final String CLEAR_CACHE_PARAM = "clearCache";
    private boolean removeMissingInSource;
    private String collection = null;
    private String dir = "/data";
    private boolean clearCache = true;
    private CompiledXQuery query;

    public String getName() {
        return "Data Sync";
    }

    public void configure(Configuration config, Properties properties) throws EXistException {
        this.collection = properties.getProperty(COLLECTION_PARAM);
        this.removeMissingInSource = Boolean.parseBoolean(properties.getProperty(REMOVE_FROM_COLLECTION_PARAM, "true"));
        this.dir = properties.getProperty(DATADIR_PARAM, DATA_DIR);
        this.clearCache = Boolean.parseBoolean(properties.getProperty(CLEAR_CACHE_PARAM, "true"));
    }

    public void execute(final DBBroker broker, final Txn transaction) throws EXistException {
        try {
            if (this.collection == null) {
                throw new EXistException(String.format("You have to provide %s parameter in conf.xml", COLLECTION_PARAM));
            }
            LOG.info(String.format("start sync %s to %s", this.dir, this.collection));
            File dataDir = new File(this.dir);
            final XmldbURI dataRoot = XmldbURI.xmldbUriFor((String)this.collection);
            final Collection data = broker.getOrCreateCollection(transaction, dataRoot);
            if (this.removeMissingInSource) {
                for (Collection.CollectionEntry ce : data.getEntries(broker)) {
                    final XmldbURI uri = ce.getUri();
                    if (dataDir.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String s) {
                            try {
                                return uri.endsWith("/" + s);
                            }
                            catch (URISyntaxException e) {
                                return false;
                            }
                        }
                    }).length != 0) continue;
                    data.removeResource(transaction, broker, data.getDocument(broker, uri));
                }
            }
            Files.walkFileTree(dataDir.toPath(), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    try {
                        XmldbURI docUri = XmldbURI.create((String)path.toFile().getName());
                        DocumentImpl document = data.getDocument(broker, dataRoot.append(path.toFile().getName()));
                        if (document == null || document.getMetadata().getLastModified() < path.toFile().lastModified()) {
                            DataSyncTask.this.storeInCollection(path, docUri, data, transaction, broker);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((document == null ? "created " : "updated ") + docUri);
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("%s not updated, file older than doc: %s, %s", docUri, new Date(path.toFile().lastModified()), new Date(document.getMetadata().getLastModified())));
                        }
                    }
                    catch (EXistException | PermissionDeniedException | LockException | SAXException e) {
                        throw new IOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
            if (this.clearCache) {
                XQuery xQuery = new XQuery();
                if (this.query == null) {
                    this.query = xQuery.compile(broker, new XQueryContext(broker.getDatabase()), (Source)new StringSource(CLEAR_CACHE_XQ));
                }
                xQuery.execute(broker, this.query, null);
            }
            transaction.commit();
            LOG.info(String.format("end sync %s to %s", this.dir, this.collection));
        }
        catch (IOException | URISyntaxException | TriggerException | PermissionDeniedException | LockException | XPathException e) {
            throw new EXistException(e);
        }
    }

    protected void storeInCollection(Path fileToStore, XmldbURI documentInCollection, Collection collection, Txn transaction, DBBroker broker) throws EXistException, PermissionDeniedException, SAXException, LockException, IOException {
        FileInputSource source = new FileInputSource(fileToStore);
        if (MimeTable.getInstance().isXMLContent(fileToStore.toFile().getName())) {
            IndexInfo indexInfo = collection.validateXMLResource(transaction, broker, documentInCollection, (InputSource)source);
            collection.store(transaction, broker, indexInfo, (InputSource)source);
        } else {
            MimeType mimeType = MimeTable.getInstance().getContentTypeFor(fileToStore.toFile().getName());
            collection.addBinaryResource(transaction, broker, documentInCollection, source.getByteStream(), mimeType.getName(), source.getByteStreamLength());
        }
    }

    public boolean afterCheckpoint() {
        return false;
    }
}

