package org.fryske_akademy.exist.lucene;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.util.Version;

import java.io.Reader;

public class CaseInsensitiveWhitespaceAnalyzer extends Analyzer {

    public CaseInsensitiveWhitespaceAnalyzer(Version version) {
    }

    public CaseInsensitiveWhitespaceAnalyzer() {
    }

    @Override
    protected TokenStreamComponents createComponents(String arg0, Reader arg1) {
        Tokenizer tokenizer = new WhitespaceTokenizer(arg1);
        TokenStream filter = new LowerCaseFilter(tokenizer);
        return new TokenStreamComponents(tokenizer, filter);
    }
}
