package org.fryske_akademy.exist.lucene;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.util.Version;

import java.io.Reader;

public class CaseInsensitiveNoSemiColonAnalyzer extends Analyzer {

    public CaseInsensitiveNoSemiColonAnalyzer(Version version) {
    }

    public CaseInsensitiveNoSemiColonAnalyzer() {
    }

    @Override
    protected TokenStreamComponents createComponents(String arg0, Reader arg1) {
        Tokenizer tokenizer = new NoSemiColonTokenizer(arg1);
        TokenStream filter = new LowerCaseFilter(tokenizer);
        return new TokenStreamComponents(tokenizer, filter);
    }
}
