/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.exist.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionFactory;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.FileInputSource;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataSyncTask
implements SystemTask {
    private static final Logger LOG = LogManager.getLogger(DataSyncTask.class);
    public static final String DATA_DIR = "/data";
    public static final String COLLECTION_PARAM = "collection";
    public static final String DATADIR_PARAM = "datadir";
    public static final String REMOVE_FROM_COLLECTION_PARAM = "removeNotInSource";
    public static final String OWNERPARAM = "owner";
    public static final String GROUPPARAM = "group";
    public static final String XMLDBPREFIX = "xmldb:exist://";
    public static final String CLEAR_CACHE_XQ = "xquery version \"3.1\";\nimport module namespace cache = \"http://exist-db.org/xquery/cache\";\ncache:clear()";
    public static final String CLEAR_CACHE_PARAM = "clearCache";
    private boolean removeMissingInSource;
    private String rootCollection = null;
    private XmldbURI dataRoot;
    private Path sourcePath;
    private boolean clearCache = true;
    private CompiledXQuery query;
    private String owner;
    private String group;

    public String getName() {
        return "Data Sync";
    }

    public void configure(Configuration config, Properties properties) throws EXistException {
        this.rootCollection = properties.getProperty(COLLECTION_PARAM);
        try {
            this.dataRoot = XmldbURI.xmldbUriFor((String)this.rootCollection);
        }
        catch (URISyntaxException e) {
            throw new EXistException((Throwable)e);
        }
        this.owner = properties.getProperty(OWNERPARAM, "");
        this.group = properties.getProperty(GROUPPARAM, "");
        this.removeMissingInSource = Boolean.parseBoolean(properties.getProperty(REMOVE_FROM_COLLECTION_PARAM, "true"));
        this.sourcePath = new File(properties.getProperty(DATADIR_PARAM, DATA_DIR)).toPath();
        this.clearCache = Boolean.parseBoolean(properties.getProperty(CLEAR_CACHE_PARAM, "true"));
    }

    public void execute(final DBBroker broker, final Txn transaction) throws EXistException {
        final ArrayList<Collection> visited = new ArrayList<Collection>();
        try {
            if (this.rootCollection == null) {
                throw new EXistException(String.format("You have to provide %s parameter in conf.xml", COLLECTION_PARAM));
            }
            LOG.info(String.format("start sync %s to %s", this.sourcePath, this.rootCollection));
            if (this.removeMissingInSource) {
                this.removeNotInSource(broker, transaction, this.dataRoot);
            }
            final AtomicBoolean success = new AtomicBoolean(true);
            Files.walkFileTree(this.sourcePath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    try {
                        Collection parent;
                        XmldbURI uri = DataSyncTask.this.dataRoot.append(DataSyncTask.this.sourcePath.relativize(path).toFile().getPath());
                        Collection collection = broker.getOrCreateCollection(transaction, uri);
                        if (DataSyncTask.this.group.isEmpty()) {
                            parent = broker.getCollection(collection.getParentURI());
                            DataSyncTask.this.group = parent == null ? "dba" : parent.getPermissionsNoLock().getGroup().getName();
                        }
                        if (DataSyncTask.this.owner.isEmpty()) {
                            parent = broker.getCollection(collection.getParentURI());
                            DataSyncTask.this.owner = parent == null ? "SYSTEM" : parent.getPermissionsNoLock().getOwner().getName();
                        }
                        visited.add(broker.openCollection(uri, Lock.LockMode.WRITE_LOCK));
                        PermissionFactory.chown((DBBroker)broker, (Collection)((Collection)visited.get(visited.size() - 1)), Optional.of(DataSyncTask.this.owner), Optional.of(DataSyncTask.this.group));
                    }
                    catch (TriggerException | PermissionDeniedException e) {
                        throw new IOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    try {
                        XmldbURI curi = DataSyncTask.this.dataRoot.append(DataSyncTask.this.sourcePath.relativize(path.getParent()).toFile().getPath());
                        Collection targetCollection = DataSyncTask.this.findCollection(curi, visited);
                        XmldbURI docUri = XmldbURI.xmldbUriFor((String)path.toFile().getName());
                        DocumentImpl document = targetCollection.getDocument(broker, docUri);
                        if (document == null || document.getMetadata().getLastModified() < path.toFile().lastModified()) {
                            DataSyncTask.this.storeInCollection(path, docUri, targetCollection, transaction, broker);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((document == null ? "created " : "updated ") + curi.append(docUri));
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("%s not updated, file older than doc: %s, %s", curi.append(docUri), new Date(path.toFile().lastModified()), new Date(document.getMetadata().getLastModified())));
                        }
                    }
                    catch (URISyntaxException | EXistException | PermissionDeniedException | LockException | SAXException e) {
                        throw new IOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
                    return DataSyncTask.this.handleIOException(path, e, success);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
                    if (e != null) {
                        return DataSyncTask.this.handleIOException(path, e, success);
                    }
                    XmldbURI curi = DataSyncTask.this.dataRoot.append(DataSyncTask.this.sourcePath.relativize(path).toFile().getPath());
                    Collection targetCollection = DataSyncTask.this.findCollection(curi, visited);
                    broker.saveCollection(transaction, targetCollection);
                    targetCollection.close();
                    return FileVisitResult.CONTINUE;
                }
            });
            if (success.get()) {
                transaction.commit();
            } else {
                this.handleError(transaction, visited);
            }
            this.clearCache(broker);
            LOG.info(String.format("%s sync %s to %s", success.get() ? "success: " : "failed: ", this.sourcePath, this.rootCollection));
        }
        catch (IOException | URISyntaxException | TriggerException | PermissionDeniedException | LockException e) {
            this.clearCache(broker);
            this.handleError(transaction, visited);
            throw new EXistException(e);
        }
    }

    private Collection findCollection(XmldbURI curi, List<Collection> visited) throws IOException {
        String collUri = this.stripXMLDBPREFIX(curi);
        return visited.stream().filter(c -> c.getURI().toString().equals(collUri)).findFirst().orElseThrow(() -> new IOException(collUri + " not found"));
    }

    private FileVisitResult handleIOException(Path path, IOException e, AtomicBoolean success) {
        success.set(false);
        LOG.error("Processing failed: " + path, (Throwable)e);
        return FileVisitResult.TERMINATE;
    }

    private void handleError(Txn transaction, List<Collection> visited) {
        transaction.abort();
        visited.forEach(collection -> collection.close());
    }

    private void clearCache(DBBroker broker) {
        if (this.clearCache) {
            try {
                XQuery xQuery = new XQuery();
                if (this.query == null) {
                    this.query = xQuery.compile(broker, new XQueryContext(broker.getDatabase()), (Source)new StringSource(CLEAR_CACHE_XQ));
                }
                xQuery.execute(broker, this.query, null);
            }
            catch (IOException | PermissionDeniedException | XPathException ex) {
                LOG.error("cache clear failed", ex);
            }
        }
    }

    private String stripXMLDBPREFIX(XmldbURI curi) {
        return curi.toString().startsWith(XMLDBPREFIX) ? curi.toString().substring(XMLDBPREFIX.length()) : curi.toString();
    }

    private void removeNotInSource(DBBroker broker, Txn transaction, XmldbURI parent) throws PermissionDeniedException, LockException, IOException, TriggerException, URISyntaxException {
        if (parent == null) {
            return;
        }
        try (Collection coll = broker.openCollection(parent, Lock.LockMode.WRITE_LOCK);){
            if (coll == null) {
                return;
            }
            String baseUri = this.stripXMLDBPREFIX(this.dataRoot);
            Iterator it = coll.collectionIterator(broker);
            while (it.hasNext()) {
                XmldbURI xmldbURI = parent.append((XmldbURI)it.next());
                XmldbURI uri = xmldbURI.toString().startsWith(XMLDBPREFIX) ? XmldbURI.xmldbUriFor((String)xmldbURI.toString().substring(XMLDBPREFIX.length())) : xmldbURI;
                this.checkRemove(uri, coll, transaction, broker, true, baseUri);
            }
            it = coll.iterator(broker);
            while (it.hasNext()) {
                XmldbURI uri = ((DocumentImpl)it.next()).getURI();
                this.checkRemove(uri, coll, transaction, broker, false, baseUri);
            }
        }
    }

    private void checkRemove(XmldbURI uri, Collection collection, Txn transaction, DBBroker broker, boolean isCollection, String baseUri) throws IOException, PermissionDeniedException, TriggerException, LockException, URISyntaxException {
        String u = uri.toString().substring(baseUri.length() + (baseUri.endsWith("/") ? 0 : 1));
        String decoded = URLDecoder.decode(u, "UTF-8");
        if (!Files.exists(this.sourcePath.resolve(decoded), new LinkOption[0])) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("removing %s, constructed from %s", uri.toString(), this.sourcePath.resolve(decoded)));
            }
            if (isCollection) {
                broker.removeCollection(transaction, broker.getCollection(uri));
            } else {
                broker.removeResource(transaction, collection.getDocument(broker, uri));
                broker.saveCollection(transaction, collection);
            }
        } else if (isCollection) {
            this.removeNotInSource(broker, transaction, uri);
        }
    }

    protected void storeInCollection(Path fileToStore, XmldbURI documentInCollection, Collection collection, Txn transaction, DBBroker broker) throws EXistException, PermissionDeniedException, SAXException, LockException, IOException {
        FileInputSource source = new FileInputSource(fileToStore);
        if (MimeTable.getInstance().isXMLContent(fileToStore.toFile().getName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("storing %s in %s", documentInCollection, collection.getURI()));
            }
            IndexInfo indexInfo = collection.validateXMLResource(transaction, broker, documentInCollection, (InputSource)source);
            PermissionFactory.chown((DBBroker)broker, (DocumentImpl)indexInfo.getDocument(), Optional.of(this.owner), Optional.of(this.group));
            collection.store(transaction, broker, indexInfo, (InputSource)source);
        } else {
            MimeType mimeType = MimeTable.getInstance().getContentTypeFor(fileToStore.toFile().getName());
            BinaryDocument document = collection.addBinaryResource(transaction, broker, documentInCollection, source.getByteStream(), mimeType.getName(), source.getByteStreamLength());
            PermissionFactory.chown((DBBroker)broker, (Txn)transaction, (XmldbURI)documentInCollection, Optional.of(this.owner), Optional.of(this.group));
        }
    }

    public boolean afterCheckpoint() {
        return false;
    }
}

