/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.exist.lucene;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.util.Version;
import org.fryske_akademy.exist.lucene.NoPunctuationTokenizer;

public class InsensitivePunctAnalyzer
extends Analyzer {
    private final boolean sensitive;

    public InsensitivePunctAnalyzer(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public InsensitivePunctAnalyzer() {
        this.sensitive = false;
    }

    public InsensitivePunctAnalyzer(Version version) {
        this();
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        NoPunctuationTokenizer tokenizer = new NoPunctuationTokenizer(reader);
        LowerCaseFilter filter = null;
        if (!this.sensitive) {
            filter = new LowerCaseFilter((TokenStream)tokenizer);
            filter = new ASCIIFoldingFilter((TokenStream)filter);
        }
        return filter == null ? new Analyzer.TokenStreamComponents((Tokenizer)tokenizer) : new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
    }
}

