/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.exist.lucene;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.util.Version;

public class InsensitiveWhitespaceAnalyzer
extends Analyzer {
    private final boolean sensitive;

    public InsensitiveWhitespaceAnalyzer(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public InsensitiveWhitespaceAnalyzer() {
        this.sensitive = false;
    }

    public InsensitiveWhitespaceAnalyzer(Version version) {
        this();
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer(reader);
        LowerCaseFilter filter = null;
        if (!this.sensitive) {
            filter = new LowerCaseFilter((TokenStream)tokenizer);
            filter = new ASCIIFoldingFilter((TokenStream)filter);
        }
        return filter == null ? new Analyzer.TokenStreamComponents((Tokenizer)tokenizer) : new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filter);
    }
}

