/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.exist.jobs;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.FileInputSource;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.xml.sax.InputSource;

public class DataSyncTask
implements SystemTask {
    private static final Logger LOG = LogManager.getLogger(DataSyncTask.class);
    public static final String DATA_DIR = "/data";
    public static final String COLLECTION_PARAM = "collection";
    public static final String DATADIR_PARAM = "datadir";
    public static final String REMOVE_FROM_COLLECTION_PARAM = "removeNotInSource";
    public static final String LOGINFO_PARAM = "logInfo";
    public static final String OWNERPARAM = "owner";
    public static final String GROUPPARAM = "group";
    public static final String XMLDBPREFIX = "xmldb:exist://";
    public static final String CLEAR_CACHE_XQ = "xquery version \"3.1\";\nimport module namespace cache = \"http://exist-db.org/xquery/cache\";\ncache:clear()";
    private static final String OWNER_QUERY = "xquery version \"3.1\";\nimport module namespace sm = \"http://exist-db.org/xquery/securitymanager\";\nfor $i in uri-collection(#c#) return sm:chown($i,#o#)";
    private static final String GROUP_QUERY = "xquery version \"3.1\";\nimport module namespace sm = \"http://exist-db.org/xquery/securitymanager\";\nfor $i in uri-collection(#c#) return sm:chgrp($i,#g#)";
    private static final String OWNER_GROUP_QUERY = "xquery version \"3.1\";\nimport module namespace sm = \"http://exist-db.org/xquery/securitymanager\";\nfor $i in uri-collection(#c#) return (sm:chown($i,#o#), sm:chgrp($i,#g#))";
    public static final String CLEAR_CACHE_PARAM = "clearCache";
    private boolean removeMissingInSource;
    private String rootCollection = null;
    private XmldbURI dataRoot;
    private Path sourcePath;
    private boolean clearCache = true;
    private String owner;
    private String group;
    private boolean logInfo = true;

    public String getName() {
        return "Data Sync";
    }

    public void configure(Configuration config, Properties properties) throws EXistException {
        this.rootCollection = properties.getProperty(COLLECTION_PARAM);
        try {
            this.dataRoot = XmldbURI.xmldbUriFor((String)this.rootCollection);
        }
        catch (URISyntaxException e) {
            throw new EXistException((Throwable)e);
        }
        this.owner = properties.getProperty(OWNERPARAM, "");
        this.group = properties.getProperty(GROUPPARAM, "");
        this.removeMissingInSource = Boolean.parseBoolean(properties.getProperty(REMOVE_FROM_COLLECTION_PARAM, "true"));
        this.logInfo = Boolean.parseBoolean(properties.getProperty(LOGINFO_PARAM, "true"));
        this.sourcePath = new File(properties.getProperty(DATADIR_PARAM, DATA_DIR)).toPath();
        this.clearCache = Boolean.parseBoolean(properties.getProperty(CLEAR_CACHE_PARAM, "true"));
    }

    public void execute(final DBBroker broker, final Txn transaction) throws EXistException {
        final ArrayList<Collection> visited = new ArrayList<Collection>();
        boolean success = false;
        try {
            if (this.rootCollection == null) {
                throw new EXistException(String.format("You have to provide %s parameter in conf.xml", COLLECTION_PARAM));
            }
            LOG.log(Level.INFO, String.format("start sync %s to %s", this.sourcePath, this.rootCollection));
            if (this.removeMissingInSource) {
                try (Collection coll = broker.openCollection(this.dataRoot, Lock.LockMode.WRITE_LOCK);){
                    this.removeNotInSource(coll, broker, transaction, this.dataRoot);
                }
            }
            Files.walkFileTree(this.sourcePath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    try {
                        Collection parent;
                        XmldbURI uri = DataSyncTask.this.dataRoot.append(DataSyncTask.this.sourcePath.relativize(path).toString());
                        broker.getOrCreateCollection(transaction, uri);
                        if (DataSyncTask.this.group.isEmpty()) {
                            parent = broker.getCollection(DataSyncTask.this.dataRoot);
                            DataSyncTask.this.group = parent.getPermissionsNoLock().getGroup().getName();
                        }
                        if (DataSyncTask.this.owner.isEmpty()) {
                            parent = broker.getCollection(DataSyncTask.this.dataRoot);
                            DataSyncTask.this.owner = parent.getPermissionsNoLock().getOwner().getName();
                        }
                        visited.add(broker.openCollection(uri, Lock.LockMode.WRITE_LOCK));
                    }
                    catch (TriggerException | PermissionDeniedException e) {
                        throw new IOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    try {
                        XmldbURI curi = DataSyncTask.this.dataRoot.append(DataSyncTask.this.sourcePath.relativize(path.getParent()).toString());
                        Collection targetCollection = DataSyncTask.this.findCollection(curi, visited);
                        XmldbURI docUri = XmldbURI.xmldbUriFor((String)URLEncoder.encode(path.getFileName().toString(), StandardCharsets.UTF_8), (boolean)false);
                        DocumentImpl document = targetCollection.getDocument(broker, docUri);
                        if (document != null && LOG.isDebugEnabled()) {
                            LOG.debug(String.format("file: %s, created %s, modified %s; coll: %s, modified %s", path.getFileName(), new Date(basicFileAttributes.creationTime().toMillis()), new Date(basicFileAttributes.lastModifiedTime().toMillis()), docUri, document == null ? "" : new Date(document.getLastModified())));
                        }
                        if (document == null || document.getLastModified() < basicFileAttributes.creationTime().toMillis() || document.getLastModified() < basicFileAttributes.lastModifiedTime().toMillis()) {
                            DataSyncTask.this.storeInCollection(path, docUri, targetCollection, transaction, broker);
                            if (DataSyncTask.this.logInfo) {
                                LOG.log(Level.INFO, (document == null ? "created: " : "updated: ") + curi.append(docUri));
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.log(Level.DEBUG, String.format("Not updated! file: %s, created %s, modified %s; coll: %s, modified %s", path.getFileName(), new Date(basicFileAttributes.creationTime().toMillis()), new Date(basicFileAttributes.lastModifiedTime().toMillis()), docUri, document == null ? "" : new Date(document.getLastModified())));
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException e) {
                    return DataSyncTask.this.handleIOException(path, e);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
                    if (e != null) {
                        return DataSyncTask.this.handleIOException(path, e);
                    }
                    XmldbURI curi = DataSyncTask.this.dataRoot.append(DataSyncTask.this.sourcePath.relativize(path).toString());
                    Collection targetCollection = DataSyncTask.this.findCollection(curi, visited);
                    targetCollection.close();
                    return FileVisitResult.CONTINUE;
                }
            });
            success = true;
            LOG.log(Level.INFO, String.format("%s sync %s to %s", "success: ", this.sourcePath, this.rootCollection));
            this.chownGrp(visited, broker);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, String.format("%s sync %s to %s", "failed: ", this.sourcePath, this.rootCollection));
            throw new EXistException((Throwable)e);
        }
        finally {
            visited.forEach(collection -> collection.close());
            if (success) {
                transaction.commit();
            } else {
                transaction.abort();
            }
            this.clearCache(broker);
        }
    }

    private Collection findCollection(XmldbURI curi, List<Collection> visited) throws IOException {
        String collUri = this.stripXMLDBPREFIX(curi);
        return visited.stream().filter(c -> c.getURI().toString().equals(collUri)).findFirst().orElseThrow(() -> new IOException(collUri + " not found"));
    }

    private FileVisitResult handleIOException(Path path, IOException e) {
        LOG.error("Processing failed: " + path, (Throwable)e);
        return FileVisitResult.TERMINATE;
    }

    private void clearCache(DBBroker broker) {
        if (this.clearCache) {
            try {
                XQuery xQuery = new XQuery();
                CompiledXQuery query = xQuery.compile(new XQueryContext(broker.getDatabase()), (Source)new StringSource(CLEAR_CACHE_XQ));
                xQuery.execute(broker, query, null);
            }
            catch (IOException | PermissionDeniedException | XPathException ex) {
                LOG.error("cache clear failed", ex);
            }
        }
    }

    private void chownGrp(List<Collection> visited, DBBroker broker) throws XPathException, PermissionDeniedException, IOException {
        XQuery xQuery = new XQuery();
        for (Collection col : visited) {
            CompiledXQuery query = null;
            String q = "";
            String uri = col.getURI().toString();
            if (this.owner.isEmpty()) {
                if (!this.group.isEmpty()) {
                    q = GROUP_QUERY.replace("#c#", this.quote(uri)).replace("#g#", this.quote(this.group));
                    query = xQuery.compile(new XQueryContext(broker.getDatabase()), (Source)new StringSource(q));
                }
            } else if (this.group.isEmpty()) {
                q = OWNER_QUERY.replace("#c#", this.quote(uri)).replace("#o#", this.quote(this.owner));
                query = xQuery.compile(new XQueryContext(broker.getDatabase()), (Source)new StringSource(q));
            } else {
                q = OWNER_GROUP_QUERY.replace("#c#", this.quote(uri)).replace("#g#", this.quote(this.group)).replace("#o#", this.quote(this.owner));
                query = xQuery.compile(new XQueryContext(broker.getDatabase()), (Source)new StringSource(q));
            }
            if (query == null) continue;
            xQuery.execute(broker, query, null);
        }
    }

    private String quote(String s) {
        return "\"" + s + "\"";
    }

    private String stripXMLDBPREFIX(XmldbURI curi) {
        return curi.toString().startsWith(XMLDBPREFIX) ? curi.toString().substring(XMLDBPREFIX.length()) : curi.toString();
    }

    private void removeNotInSource(Collection coll, DBBroker broker, Txn transaction, XmldbURI parent) throws PermissionDeniedException, LockException, IOException, TriggerException, URISyntaxException {
        if (parent == null || coll == null) {
            return;
        }
        String baseUri = this.stripXMLDBPREFIX(this.dataRoot);
        Iterator it = coll.collectionIterator(broker);
        while (it.hasNext()) {
            XmldbURI xmldbURI = parent.append((XmldbURI)it.next());
            XmldbURI uri = xmldbURI.toString().startsWith(XMLDBPREFIX) ? XmldbURI.xmldbUriFor((String)xmldbURI.toString().substring(XMLDBPREFIX.length())) : xmldbURI;
            this.checkRemove(uri, coll, transaction, broker, true, baseUri);
        }
        it = coll.iterator(broker);
        while (it.hasNext()) {
            XmldbURI uri = ((DocumentImpl)it.next()).getURI();
            this.checkRemove(uri, coll, transaction, broker, false, baseUri);
        }
    }

    private void checkRemove(XmldbURI uri, Collection collection, Txn transaction, DBBroker broker, boolean isCollection, String baseUri) throws IOException, PermissionDeniedException, TriggerException, LockException, URISyntaxException {
        String u = uri.toString().substring(baseUri.length() + (baseUri.endsWith("/") ? 0 : 1));
        String decoded = URLDecoder.decode(u, "UTF-8");
        if (!Files.exists(this.sourcePath.resolve(decoded), new LinkOption[0])) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("removing %s, constructed from %s", uri.toString(), this.sourcePath.resolve(decoded)));
            }
            if (isCollection) {
                broker.removeCollection(transaction, broker.getCollection(uri));
                broker.saveCollection(transaction, collection);
            } else {
                broker.removeResource(transaction, collection.getDocument(broker, uri));
            }
        } else if (isCollection) {
            try (Collection coll = broker.openCollection(uri, Lock.LockMode.WRITE_LOCK);){
                this.removeNotInSource(coll, broker, transaction, uri);
            }
        }
    }

    protected void storeInCollection(Path fileToStore, XmldbURI documentInCollection, Collection collection, Txn transaction, DBBroker broker) throws Exception {
        FileInputSource source = new FileInputSource(fileToStore);
        MimeType mimeType = MimeTable.getInstance().getContentTypeFor(fileToStore.getFileName().toString());
        if (mimeType != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("storing %s in %s", documentInCollection, collection.getURI()));
            }
            broker.storeDocument(transaction, documentInCollection, (InputSource)source, mimeType, collection);
        } else {
            LOG.log(Level.WARN, String.format("unable to determine mimetype for %s", fileToStore.getFileName()));
        }
    }

    public boolean afterCheckpoint() {
        return false;
    }
}

