package org.fryske_akademy.jsf.util;

/*-
 * #%L
 * guiCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.security.Principal;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.fryske_akademy.ejb.AbstractCrudService;

public class JsfUtil {

    public static SelectItem[] getSelectItems(List<?> entities, boolean selectOne) {
        int size = selectOne ? entities.size() + 1 : entities.size();
        SelectItem[] items = new SelectItem[size];
        int i = 0;
        if (selectOne) {
            items[0] = new SelectItem("", "---");
            i++;
        }
        for (Object x : entities) {
            items[i++] = new SelectItem(x, x.toString());
        }
        return items;
    }

    public static boolean isValidationFailed() {
        return FacesContext.getCurrentInstance().isValidationFailed();
    }

    public static void addErrorMessage(Exception ex, String defaultMsg) {
        String msg = ex.getLocalizedMessage();
        if (msg != null && msg.length() > 0) {
            addErrorMessage(msg);
        } else {
            addErrorMessage(defaultMsg);
        }
    }

    public static void addErrorMessages(List<String> messages) {
        for (String message : messages) {
            addErrorMessage(message);
        }
    }

    public static void addErrorMessage(String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        FacesContext.getCurrentInstance().addMessage(null, facesMsg);
    }

    public static void addSuccessMessage(String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
        FacesContext.getCurrentInstance().addMessage("successInfo", facesMsg);
    }

    public static String getRequestParameter(String key) {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(key);
    }

    public static Object getObjectFromRequestParameter(String requestParameterName, Converter converter, UIComponent component) {
        String theId = JsfUtil.getRequestParameter(requestParameterName);
        return converter.getAsObject(FacesContext.getCurrentInstance(), component, theId);
    }

    public static <T> T findInContext(String name, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T) facesContext.getApplication().getELResolver().
                getValue(facesContext.getELContext(), null, name);
    }

    public static <T> T findOrCreateInContext(String name, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T) facesContext.getApplication().evaluateExpressionGet(facesContext, name, clazz);
    }
    
    public static <T extends Converter> void registerConverter(String id, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getApplication().addConverter(id, clazz.getName());
    }
    
    public static <T extends Converter> T getConverter(String id, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().createConverter(id);
    }

    /**
     * context path plus servlet path
     *
     * @return
     */
    public static String fullServletPath() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
    }

    public static String contextPath() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return externalContext.getRequestContextPath();
    }

    public static enum PersistAction {
        CREATE,
        DELETE,
        UPDATE
    }

    public static String split(String toSplit, int index) {
        if (toSplit==null) {
            return toSplit;
        }
        String[] split = toSplit.split(": ?");
        return (index < split.length) ? split[index] : null;
    }

    public static Throwable deepestCause(Throwable t) {
        if (t.getCause() != null) {
            return deepestCause(t.getCause());
        }
        return t;
    }

    public static Principal findPrinciple() {
        return FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
    }
    
    public static void logout() throws ServletException {
        FacesContext.getCurrentInstance().getExternalContext().invalidateSession();
        ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).logout();
    }
    
    /**
     * return a resource for the current locale
     * @param bundle
     * @return 
     */
    public static ResourceBundle getLocaleBundle(String bundle) {
        Locale loc = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        return ResourceBundle.getBundle(bundle,loc);
    }
    
    public static boolean mayEdit() {
        return FacesContext.getCurrentInstance().getExternalContext().isUserInRole(AbstractCrudService.EDITOR);
    }
}
