/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf.lazy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.bean.SessionScoped;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.JpqlBuilder;
import org.fryske_akademy.ejb.ParamInfo;
import org.fryske_akademy.ejb.SortBuilder;
import org.fryske_akademy.jpa.AbstractEntity;
import org.fryske_akademy.jsf.Filtering;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

@SessionScoped
public abstract class AbstractLazyModel<T extends AbstractEntity>
extends LazyDataModel<T>
implements Filtering<T> {
    @EJB
    private CrudReadService crudReadService;
    private final Class<T> clazz;
    private final AtomicBoolean selecting = new AtomicBoolean();
    private final Map<String, Object> filters = new HashMap<String, Object>(3){

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                this.put(String.valueOf(key), null);
            }
            return super.get(key);
        }
    };
    private List<T> filtered;

    public AbstractLazyModel(Class<T> clazz) {
        this.clazz = clazz;
    }

    public CrudReadService getCrudReadService() {
        return this.crudReadService;
    }

    public T getRowData(String rowKey) {
        return (T)((AbstractEntity)this.crudReadService.find((Serializable)Integer.valueOf(rowKey), this.clazz));
    }

    @PostConstruct
    public void init() {
        List<T> load = this.load(0, this.getPageSize(), null, null, null);
        this.setWrappedData(load);
        this.setRowCount(this.crudReadService.count(null, this.clazz));
    }

    protected List<ParamInfo> convertFilters(Map<String, Object> filters) {
        if (filters == null) {
            return null;
        }
        ParamInfo.ParamInfoBuilder builder = new ParamInfo.ParamInfoBuilder();
        for (Map.Entry<String, Object> p : filters.entrySet()) {
            this.addToParamBuilder(builder, p.getKey(), p.getValue());
        }
        return builder.build();
    }

    protected void addToParamBuilder(ParamInfo.ParamInfoBuilder builder, String key, Object value) {
        if (!(value instanceof Boolean) || ((Boolean)value).booleanValue()) {
            builder.add(key, value);
        }
    }

    public final List<T> load(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        ArrayList<SortMeta> s = new ArrayList<SortMeta>(1);
        s.add(new SortMeta(null, sortField, sortOrder, null));
        return this.load(first, pageSize, s, filters);
    }

    public List<T> load(int first, int pageSize, List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        if (this.selecting.getAndSet(false)) {
            return null;
        }
        SortBuilder sortBuilder = new SortBuilder();
        if (multiSortMeta != null) {
            multiSortMeta.forEach(h -> sortBuilder.add(h.getSortField(), AbstractLazyModel.convert(h.getSortOrder())));
        }
        List<ParamInfo> convertFilters = this.convertFilters(filters);
        List load = this.crudReadService.findPaged(first, pageSize, sortBuilder.build(), convertFilters, this.clazz);
        this.setWrappedData(load);
        this.setRowCount(this.crudReadService.count(convertFilters, this.clazz));
        if (filters != null && !filters.isEmpty()) {
            this.clear();
            this.filters.putAll(filters);
        }
        return load;
    }

    public static JpqlBuilder.SORTORDER convert(SortOrder order) {
        if (order == null) {
            return null;
        }
        switch (order) {
            case ASCENDING: {
                return JpqlBuilder.SORTORDER.ASC;
            }
        }
        return JpqlBuilder.SORTORDER.DESC;
    }

    @Override
    public List<T> getFiltered() {
        return this.filtered;
    }

    @Override
    public void setFiltered(List<T> filtered) {
        this.filtered = filtered;
    }

    @Override
    public Map<String, Object> getFilters() {
        return this.filters;
    }

    @Override
    public final void select(String key, String value) {
        this.selecting.set(false);
        HashMap<String, Object> f = new HashMap<String, Object>(1);
        f.put(key, value);
        this.setFiltered(this.load(0, 10, null, null, f));
        this.selecting.set(true);
    }

    @Override
    public void clear() {
        this.filters.clear();
    }
}

