/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.Serializable;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import javax.security.enterprise.SecurityContext;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.CrudWriteService;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jsf.util.JsfUtil;

public abstract class AbstractController
implements Serializable {
    public static final String FACESREDIRECTTRUE = "?faces-redirect=true";
    @Inject
    private SecurityContext securityContext;

    public abstract CrudReadService getCrudReadService();

    public abstract CrudWriteService getCrudWriteService();

    public <T extends EntityInterface> T persist(T edited, PersistAction persistAction) throws Exception {
        return this.persist(edited, persistAction, (Object)((Object)persistAction) + " success");
    }

    public <T extends EntityInterface> T persist(T edited, PersistAction persistAction, String successMessage) throws Exception {
        return this.persist(edited, persistAction, successMessage, true);
    }

    public <T extends EntityInterface> T persist(T edited, PersistAction persistAction, String successMessage, boolean callHandle) throws Exception {
        block8: {
            if (edited != null) {
                Converter converter = JsfUtil.getConverter(edited.getClass());
                try {
                    switch (persistAction) {
                        case CREATE: {
                            edited = (EntityInterface)this.getCrudWriteService().create(edited);
                            break;
                        }
                        case UPDATE: {
                            edited = (EntityInterface)this.getCrudWriteService().update(edited);
                            break;
                        }
                        case DELETE: {
                            this.getCrudWriteService().delete(edited);
                        }
                    }
                    JsfUtil.addSuccessMessage(successMessage + " " + (converter != null ? converter.getAsString(null, null, edited) : edited));
                }
                catch (Exception ex) {
                    if (!callHandle) break block8;
                    JsfUtil.handleException(ex, (Object)((Object)persistAction) + " " + (converter != null ? converter.getAsString(null, null, edited) : edited) + " failed: ");
                }
            }
        }
        return edited;
    }

    public String diacriticsKeyBoard() {
        return "\u00e0\u00e1\u00e4\u00e2\u00c0\u00c1\u00c2\u00c4\u00e5\u00c5-back,\u00e8\u00e9\u00eb\u00ea\u00c8\u00c9\u00ca\u00cb-clear,\u00ec\u00ed\u00ef\u00ee\u00cc\u00cd\u00ce\u00cf-close,\u00f2\u00f3\u00f6\u00f4\u00d2\u00d3\u00d4\u00d6,\u00f9\u00fa\u00fc\u00fb\u00d9\u00da\u00db\u00dc,*?";
    }

    protected SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public static enum PersistAction {
        CREATE,
        DELETE,
        UPDATE;

    }
}

