/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;

public class AjaxSessionTimeoutListener
implements PhaseListener {
    private static final Logger LOGGER = Logger.getLogger(AjaxSessionTimeoutListener.class.getName());
    public static final String LOGINPATH = "/login.xhtml";

    protected String getLoginPath() {
        return LOGINPATH;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (!facesContext.getPartialViewContext().isAjaxRequest() || facesContext.getRenderResponse()) {
            if (facesContext.getRenderResponse() && LOGGER.isLoggable(Level.FINE)) {
                HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(facesContext.getExternalContext().getRequest());
                LOGGER.fine(String.format("response rendered, not handling %s", request.getServletPath()));
            }
            return;
        }
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(facesContext.getExternalContext().getRequest());
        if (request.getDispatcherType() == DispatcherType.FORWARD && this.getLoginPath().equals(request.getServletPath())) {
            try {
                this.handleAjaxAfterTimeout(facesContext, request);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "unable to redirect", e);
            }
        }
    }

    protected void handleAjaxAfterTimeout(FacesContext facesContext, HttpServletRequest request) throws IOException {
        facesContext.getExternalContext().redirect(this.getTimeoutPath(request));
    }

    protected String getTimeoutPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    public void afterPhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

