/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fryske_akademy.jsf.util.JsfUtil;

public class CookieHelper {
    public static void replaceCookie(String name, String value, int expiry, HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(name)) continue;
                c.setMaxAge(0);
                c.setValue(null);
                response.addCookie(c);
            }
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(JsfUtil.contextPath());
        cookie.setSecure(true);
        cookie.setMaxAge(expiry);
        response.addCookie(cookie);
    }

    public static Cookie getCookie(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }
}

