/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf.util;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.fryske_akademy.Util;

public class JsfUtil {
    private static final Logger LOGGER = Logger.getLogger(JsfUtil.class.getName());
    private static final ResourceBundle rootBundle = ResourceBundle.getBundle("EMPTY", Locale.ROOT);

    public static void handleException(Exception ex, String prefix) throws Exception {
        FacesContext.getCurrentInstance().validationFailed();
        JsfUtil.addErrorMessage(prefix + Util.deepestCause((Throwable)ex).getLocalizedMessage());
        throw ex;
    }

    public static boolean isValidationFailed() {
        return FacesContext.getCurrentInstance().isValidationFailed();
    }

    public static void addErrorMessage(Exception ex, String defaultMsg) {
        String msg = ex.getLocalizedMessage();
        if (msg != null && msg.length() > 0) {
            JsfUtil.addErrorMessage(msg);
        } else {
            JsfUtil.addErrorMessage(defaultMsg);
        }
    }

    public static void addErrorMessages(List<String> messages) {
        for (String message : messages) {
            JsfUtil.addErrorMessage(message);
        }
    }

    public static void addErrorMessage(String msg) {
        String cid = null;
        JsfUtil.addErrorMessage(cid, msg);
    }

    public static void addErrorMessage(String clientId, String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMsg);
    }

    public static void addSuccessMessage(String msg) {
        JsfUtil.addSuccessMessage("successInfo", msg);
    }

    public static void addSuccessMessage(String clientId, String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMsg);
    }

    public static <T> T findInContext(Class<T> clazz) {
        return JsfUtil.findInContext(Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1), clazz);
    }

    public static <T> T findInContext(String name, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().getELResolver().getValue(facesContext.getELContext(), null, (Object)name);
    }

    public static <T> T findOrCreateInContext(String name, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().evaluateExpressionGet(facesContext, name, clazz);
    }

    public static Converter getConverter(Class clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().createConverter(clazz);
    }

    public static String fullServletPath() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
    }

    public static String contextPath() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return externalContext.getRequestContextPath();
    }

    public static void redirectToServletPath(String servletPath) throws IOException {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        externalContext.redirect(externalContext.getRequestContextPath() + servletPath);
    }

    public static void logout() throws ServletException {
        FacesContext.getCurrentInstance().getExternalContext().invalidateSession();
        ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).logout();
    }

    public static ResourceBundle getLocaleBundle(String bundle) {
        Locale loc = FacesContext.getCurrentInstance() != null ? FacesContext.getCurrentInstance().getViewRoot().getLocale() : Locale.getDefault();
        try {
            return ResourceBundle.getBundle(bundle, loc);
        }
        catch (MissingResourceException e) {
            LOGGER.warning("resource not found: " + bundle + ", returning EMPTY");
            return rootBundle;
        }
    }

    public static String getFromBundle(ResourceBundle bundle, String key) {
        if (bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        LOGGER.warning(String.format("%s not found in language bundle %s", key, bundle));
        return key;
    }
}

