/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import org.fryske_akademy.ejb.Auditing;
import org.fryske_akademy.jpa.AbstractEntity;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jsf.Filtering;
import org.fryske_akademy.jsf.util.JsfUtil;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;

@SessionScoped
public abstract class AbstractCrudController<T extends AbstractEntity, S extends Auditing> {
    private S crudWriteService;
    protected T selected;
    protected T newEntity;
    protected final Class<T> clazz;
    private boolean rememberTableState = true;

    public boolean isRememberTableState() {
        return this.rememberTableState;
    }

    public void setRememberTableState(boolean rememberTableState) {
        this.rememberTableState = rememberTableState;
    }

    public AbstractCrudController(Class<T> clazz) {
        this.clazz = clazz;
    }

    public S getCrudWriteService() {
        return this.crudWriteService;
    }

    public T getSelected() {
        return this.selected;
    }

    public void setSelected(T selected) {
        this.selected = selected;
    }

    public T getNewEntity() {
        return this.newEntity;
    }

    public void setNewEntity(T newEntity) {
        this.newEntity = newEntity;
    }

    public void onRowSelect(SelectEvent event) {
        if (event != null) {
            this.setSelected((AbstractEntity)event.getObject());
        }
    }

    public final void prepareCreate() throws InstantiationException, IllegalAccessException {
        this.newEntity = (AbstractEntity)this.clazz.newInstance();
        this.fillNew(this.newEntity);
    }

    public T create() {
        T persisted = this.persist(this.newEntity, JsfUtil.PersistAction.CREATE, JsfUtil.getLocaleBundle("/Bundle").getString("Created"));
        if (!JsfUtil.isValidationFailed()) {
            this.gotoPageContaining(persisted);
        }
        return persisted;
    }

    public abstract Filtering<T> getFiltering();

    protected abstract void gotoPageContaining(T var1);

    protected abstract void fillCopy(T var1, T var2);

    protected void fillNew(T entity) {
    }

    public final void copy() throws InstantiationException, IllegalAccessException {
        if (this.selected != null) {
            AbstractEntity l = (AbstractEntity)this.clazz.newInstance();
            this.fillCopy(l, this.getSelected());
            this.newEntity = l;
        }
    }

    public void update(RowEditEvent editEvent) {
        this.persist((AbstractEntity)editEvent.getObject(), JsfUtil.PersistAction.UPDATE, JsfUtil.getLocaleBundle("/Bundle").getString("Updated"));
    }

    public void destroy() {
        this.persist(this.selected, JsfUtil.PersistAction.DELETE, JsfUtil.getLocaleBundle("/Bundle").getString("Deleted"));
        if (!JsfUtil.isValidationFailed()) {
            this.selected = null;
        }
    }

    protected final T persist(T edited, JsfUtil.PersistAction persistAction, String successMessage) {
        if (edited != null) {
            try {
                if (persistAction != JsfUtil.PersistAction.DELETE) {
                    AbstractEntity saveOrUpdate;
                    AbstractEntity abstractEntity = saveOrUpdate = edited.isTransient() ? (AbstractEntity)this.crudWriteService.create(edited) : (AbstractEntity)this.crudWriteService.update(edited);
                    if (edited.getVersion() != saveOrUpdate.getVersion()) {
                        JsfUtil.addSuccessMessage(successMessage + edited.getId());
                    }
                    edited.setVersion(saveOrUpdate.getVersion());
                    edited = saveOrUpdate;
                } else {
                    this.crudWriteService.delete(edited);
                    JsfUtil.addSuccessMessage(successMessage + edited.getId());
                }
            }
            catch (EJBException ex) {
                FacesContext.getCurrentInstance().validationFailed();
                String msg = "failed " + (Object)((Object)persistAction) + ": ";
                Throwable cause = JsfUtil.deepestCause(ex);
                if (cause != null) {
                    msg = msg + cause.getLocalizedMessage();
                }
                if (msg.length() > 0) {
                    JsfUtil.addErrorMessage(msg);
                } else {
                    JsfUtil.addErrorMessage((Exception)((Object)ex), JsfUtil.getLocaleBundle("/Bundle").getString("PersistenceErrorOccured"));
                }
            }
            catch (Exception ex) {
                FacesContext.getCurrentInstance().validationFailed();
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                JsfUtil.addErrorMessage(ex, JsfUtil.getLocaleBundle("/Bundle").getString("PersistenceErrorOccured"));
            }
        }
        return edited;
    }

    public String getLastChangedInfo(T entity) {
        List revisions = this.crudWriteService.getRevisionInfo((Serializable)entity.getId(), Integer.valueOf(1), this.clazz);
        if (revisions.isEmpty()) {
            return "no changes";
        }
        RevInfo rev = (RevInfo)revisions.get(0);
        return rev.getRevisionInfo().getUsername() + " at " + rev.getRevisionInfo().getRevisionDate() + " (" + rev.getType() + ")";
    }

    public List<RevInfo<T>> getLastChanged(T entity, int max) {
        return this.crudWriteService.getRevisionInfo(entity, Integer.valueOf(max), this.clazz);
    }

    protected final void setCrudWriteService(S crudWriteService) {
        this.crudWriteService = crudWriteService;
    }

    protected abstract void initCrudWriteService(S var1);
}

