/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.fryske_akademy.jsf.util.CookieHelper;
import org.fryske_akademy.jsf.util.JsfUtil;

@SessionScoped
public class SessionBean
implements Serializable {
    public static final String LANGUAGE_COOKIE = "language";
    public static final String THEME_COOKIE = "theme";
    private String language;
    private Locale locale;
    private static final Map<String, Locale> languageLocales = new HashMap<String, Locale>(3);
    private static final List<String> languages = new ArrayList<String>(3);
    private static final List<String> themes = new ArrayList<String>(40);
    private String currentTheme = themes.get(2);

    @PostConstruct
    private void init() {
        this.initLanguages();
        this.initFromCookies();
    }

    public List<String> getThemes() {
        return themes;
    }

    public String getCurrentTheme() {
        return this.currentTheme;
    }

    public void setCurrentTheme(String currentTheme) {
        this.currentTheme = currentTheme;
    }

    public void themeChanged(ValueChangeEvent event) {
        this.setCurrentTheme((String)event.getNewValue());
        CookieHelper.replaceCookie(THEME_COOKIE, this.currentTheme);
    }

    protected final void addLanguage(String name, String code, String region) {
        languageLocales.put(name, new Locale(code, region));
        if (!languages.contains(name)) {
            languages.add(name);
        }
    }

    protected void initFromCookies() {
        Cookie cookie = CookieHelper.getCookie(LANGUAGE_COOKIE);
        this.setLanguage(cookie != null ? cookie.getValue() : "Frisian");
        cookie = CookieHelper.getCookie(THEME_COOKIE);
        this.setCurrentTheme(cookie != null ? cookie.getValue() : "afterwork");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLanguages() {
        Map<String, Locale> map = languageLocales;
        synchronized (map) {
            if (languageLocales.isEmpty()) {
                this.addLanguage("Frisian", "fy", "NL");
                this.addLanguage("Dutch", "nl", "NL");
                this.addLanguage("English", "en", "EN");
            }
        }
    }

    public List<String> getLanguages() {
        return languages;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.locale = languageLocales.get(language);
        FacesContext.getCurrentInstance().getViewRoot().setLocale(this.locale);
        this.language = language;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean mayEdit() {
        return JsfUtil.mayEdit();
    }

    public void languageChanged(ValueChangeEvent e) {
        this.setLanguage((String)e.getNewValue());
        CookieHelper.replaceCookie(LANGUAGE_COOKIE, this.language);
    }

    public String getUser() {
        Principal p = JsfUtil.findPrinciple();
        return p == null ? "not logged in" : p.getName();
    }

    public void logout() {
        try {
            JsfUtil.logout();
            FacesContext.getCurrentInstance().getExternalContext().redirect(JsfUtil.contextPath() + "/login.xhtml");
        }
        catch (IOException | ServletException ex) {
            Logger.getLogger(SessionBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        themes.add("afterdark");
        themes.add("afternoon");
        themes.add("afterwork");
        themes.add("aristo");
        themes.add("black-tie");
        themes.add("blitzer");
        themes.add("bluesky");
        themes.add("bootstrap");
        themes.add("casablanca");
        themes.add("cupertino");
        themes.add("cruze");
        themes.add("dark-hive");
        themes.add("delta");
        themes.add("dot-luv");
        themes.add("eggplant");
        themes.add("excite-bike");
        themes.add("flick");
        themes.add("glass-x");
        themes.add("home");
        themes.add("hot-sneaks");
        themes.add("humanity");
        themes.add("le-frog");
        themes.add("midnight");
        themes.add("mint-choc");
        themes.add("overcast");
        themes.add("pepper-grinder");
        themes.add("redmond");
        themes.add("rocket");
        themes.add("sam");
        themes.add("smoothness");
        themes.add("south-street");
        themes.add("start");
        themes.add("sunny");
        themes.add("swanky-purse");
        themes.add("trontastic");
        themes.add("ui-darkness");
        themes.add("ui-lightness");
        themes.add("vader");
    }
}

