/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.fryske_akademy.jsf.util.CookieHelper;
import org.fryske_akademy.jsf.util.JsfUtil;

@SessionScoped
public class SessionBean
implements Serializable {
    public static final String LANGUAGE_COOKIE = "language";
    public static final String THEME_COOKIE = "theme";
    private String language;
    private Locale locale;
    private static final Map<String, Locale> languageLocales = new HashMap<String, Locale>(3);
    private static final List<String> languages = new ArrayList<String>(3);
    private final List<String> themes = new ArrayList<String>(40);
    private String currentTheme;

    public SessionBean() {
        this.addTheme("aristo").addTheme("omega");
        this.currentTheme = this.themes.get(0);
    }

    protected SessionBean addTheme(String theme) {
        if (!this.themes.contains(theme)) {
            this.themes.add(theme);
        }
        return this;
    }

    @PostConstruct
    private void init() {
        this.initLanguages();
        this.initFromCookies();
    }

    public final List<String> getThemes() {
        return this.themes;
    }

    public String getCurrentTheme() {
        return this.currentTheme;
    }

    public final void setCurrentTheme(String currentTheme) {
        if (!this.themes.contains(currentTheme)) {
            throw new IllegalArgumentException(currentTheme + " not supported");
        }
        this.currentTheme = currentTheme;
    }

    public void themeChanged(ValueChangeEvent event) {
        this.setCurrentTheme((String)event.getNewValue());
        CookieHelper.replaceCookie(THEME_COOKIE, this.currentTheme);
    }

    protected final void addLanguage(String name, String code, String region) {
        languageLocales.put(name, new Locale(code, region));
        if (!languages.contains(name)) {
            languages.add(name);
        }
    }

    protected void initFromCookies() {
        Cookie cookie = CookieHelper.getCookie(LANGUAGE_COOKIE);
        this.setLanguage(cookie != null ? cookie.getValue() : "Frisian");
        cookie = CookieHelper.getCookie(THEME_COOKIE);
        this.setCurrentTheme(cookie != null ? cookie.getValue() : "aristo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLanguages() {
        Map<String, Locale> map = languageLocales;
        synchronized (map) {
            if (languageLocales.isEmpty()) {
                this.addLanguage("Frisian", "fy", "NL");
                this.addLanguage("Dutch", "nl", "NL");
                this.addLanguage("English", "en", "EN");
            }
        }
    }

    public List<String> getLanguages() {
        return languages;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (!languageLocales.containsKey(language)) {
            throw new IllegalArgumentException(language + " not supported");
        }
        this.locale = languageLocales.get(language);
        FacesContext.getCurrentInstance().getViewRoot().setLocale(this.locale);
        this.language = language;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean mayEdit(String role) {
        return JsfUtil.mayEdit(role);
    }

    public boolean mayEdit() {
        return JsfUtil.mayEdit();
    }

    public void languageChanged(ValueChangeEvent e) {
        this.setLanguage((String)e.getNewValue());
        CookieHelper.replaceCookie(LANGUAGE_COOKIE, this.language);
    }

    public String getUser() {
        Principal p = JsfUtil.findPrinciple();
        return p == null ? "not logged in" : p.getName();
    }

    public void logout() {
        try {
            JsfUtil.logout();
            FacesContext.getCurrentInstance().getExternalContext().redirect(JsfUtil.contextPath() + "/login.xhtml");
        }
        catch (IOException | ServletException ex) {
            Logger.getLogger(SessionBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

