/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf.lazy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.faces.bean.SessionScoped;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.Param;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jsf.AbstractLazyController;
import org.fryske_akademy.jsf.Filtering;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

@SessionScoped
public abstract class AbstractLazyModel<T extends EntityInterface>
extends LazyDataModel<T>
implements Filtering<T> {
    private final Class<T> clazz;
    private CrudReadService crudReadService;
    private final AtomicBoolean selecting = new AtomicBoolean();
    private final AtomicBoolean tableState = new AtomicBoolean();
    private final Map<String, Object> filters = new HashMap<String, Object>(3){

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                this.put(String.valueOf(key), null);
            }
            return super.get(key);
        }
    };
    private List<T> filtered;

    protected abstract AbstractLazyController getLazyController();

    public AbstractLazyModel(Class<T> clazz) {
        this.clazz = clazz;
    }

    public CrudReadService getCrudReadService() {
        return this.crudReadService;
    }

    public T getRowData(String rowKey) {
        return (T)((EntityInterface)this.crudReadService.find((Serializable)Integer.valueOf(rowKey), this.clazz));
    }

    @PostConstruct
    private void post() {
        if (this.crudReadService == null) {
            throw new IllegalStateException("Please inject crudReadService via initCrudReadService() and a call to setCrudReadService()");
        }
        this.init();
    }

    protected void init() {
        List<T> load = this.load(0, this.getPageSize(), null, null, null);
        this.setWrappedData(load);
        this.setRowCount(this.crudReadService.countDynamic(null, this.clazz));
    }

    protected Param.Builder initParamBuilder() {
        return new Param.Builder(this.getLazyController().isSyntaxInvalue(), Param.Builder.DEFAULT_MAPPING);
    }

    protected final List<Param> convertFilters(Map<String, Object> filters) {
        if (filters == null) {
            return null;
        }
        Param.Builder builder = this.initParamBuilder();
        for (Map.Entry<String, Object> p : filters.entrySet()) {
            this.addToParamBuilder(builder, p.getKey(), p.getValue());
        }
        return builder.build();
    }

    protected void addToParamBuilder(Param.Builder builder, String key, Object value) {
        if (!(value instanceof Boolean) || ((Boolean)value).booleanValue()) {
            builder.add(key, value, this.getLazyController().isUseOr());
        }
    }

    public final List<T> load(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        ArrayList<SortMeta> s = new ArrayList<SortMeta>(1);
        s.add(new SortMeta(null, sortField, sortOrder, null));
        return this.load(first, pageSize, s, filters);
    }

    public final List<T> load(int first, int pageSize, List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        if (this.selecting.getAndSet(false)) {
            this.getLazyController().setRememberTableState(this.tableState.get());
            return null;
        }
        CrudReadService.SORTORDER.Builder sortBuilder = new CrudReadService.SORTORDER.Builder();
        if (multiSortMeta != null) {
            multiSortMeta.forEach(h -> sortBuilder.add(h.getSortField(), AbstractLazyModel.convert(h.getSortOrder())));
        }
        List<Param> convertFilters = this.convertFilters(filters);
        List load = this.crudReadService.findDynamic(Integer.valueOf(first), Integer.valueOf(pageSize), sortBuilder.build(), convertFilters, this.clazz);
        this.setWrappedData(load);
        this.setRowCount(this.crudReadService.countDynamic(convertFilters, this.clazz));
        if (filters != null && !filters.isEmpty()) {
            this.clear();
            this.filters.putAll(filters);
        }
        return load;
    }

    public static CrudReadService.SORTORDER convert(SortOrder order) {
        if (order == null) {
            return null;
        }
        switch (order) {
            case ASCENDING: {
                return CrudReadService.SORTORDER.ASC;
            }
        }
        return CrudReadService.SORTORDER.DESC;
    }

    @Override
    public List<T> getFiltered() {
        return this.filtered;
    }

    @Override
    public void setFiltered(List<T> filtered) {
        this.filtered = filtered;
    }

    @Override
    public Map<String, Object> getFilters() {
        return this.filters;
    }

    @Override
    public final void select(String key, String value, int maxResults) {
        this.selecting.set(false);
        HashMap<String, Object> f = new HashMap<String, Object>(1);
        f.put(key, value);
        this.setFiltered(this.load(0, maxResults, null, null, f));
        this.tableState.set(this.getLazyController().isRememberTableState());
        this.getLazyController().setRememberTableState(false);
        this.selecting.set(true);
    }

    @Override
    public void clear() {
        this.filters.clear();
    }

    protected final void setCrudReadService(CrudReadService crudReadService) {
        this.crudReadService = crudReadService;
    }

    protected abstract void initCrudWriteService(CrudReadService var1);
}

