/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fryske_akademy.jsf;

/*-
 * #%L
 * guiCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
import javax.annotation.PostConstruct;
import javax.faces.bean.SessionScoped;
import org.fryske_akademy.ejb.CrudWriteService;
import org.fryske_akademy.jpa.AbstractEntity;
import org.fryske_akademy.jsf.util.JsfUtil;

/**
 * Controller for views that are not single entity oriented
 * @author eduard
 */
@SessionScoped
public abstract class AbstractController<S extends CrudWriteService> {

    private S crudWriteService;
    
    @PostConstruct
    private void post() {
        if (crudWriteService==null) {
            throw new IllegalStateException("Please inject crudWriteService via initCrudWriteService() and a call to setCrudWriteService()");
        }
    }

    public S getCrudWriteService() {
        return crudWriteService;
    }

    /**
     * Calls {@link CrudWriteService#create(java.io.Serializable) }, update or delete, calls {@link JsfUtil#addSuccessMessage(java.lang.String) } 
     * and in case of an exception {@link JsfUtil#handleException(java.lang.Exception, java.lang.String) }.
     * @param edited
     * @param persistAction
     * @param successMessage
     * @return the up to date or deleted entity
     */
    protected final <T extends AbstractEntity> T persist(T edited, JsfUtil.PersistAction persistAction, String successMessage) {
        if (edited != null) {
            try {
                if (persistAction != JsfUtil.PersistAction.DELETE) {
                    T saveOrUpdate = edited.isTransient() ? crudWriteService.create(edited) : crudWriteService.update(edited);
                    if (edited.getVersion() != saveOrUpdate.getVersion()) {
                        JsfUtil.addSuccessMessage(successMessage + (edited.getId()));
                    }
                    edited.setVersion(saveOrUpdate.getVersion());
                    edited = saveOrUpdate;
                } else {
                    crudWriteService.delete(edited);
                    JsfUtil.addSuccessMessage(successMessage + (edited.getId()));
                }
            } catch (Exception ex) {
                JsfUtil.handleException(ex, persistAction + " failed: ");
            }
        }
        return edited;
    }
    
    /**
     * for use in primefaces keyboard layoutTemplate
     * @return 
     */
    public String diacriticsKeyBoard() {
        return "àáäâÀÁÂÄåÅ-back,èéëêÈÉÊË-clear,ìíïîÌÍÎÏ-close,òóöôÒÓÔÖ,ùúüûÙÚÛÜ,*?";
    }

    /**
     * call this from your Inject annotated set method
     *
     * @param crudWriteService
     */
    protected final void setCrudWriteService(S crudWriteService) {
        this.crudWriteService = crudWriteService;
    }

    /**
     * implement, annotate with @Inject (@EJB should work but no success yet)
     * and call {@link #setCrudWriteService(org.fryske_akademy.ejb.Auditing) }
     *
     * @param crudWriteService
     */
    protected abstract void initCrudWriteService(S crudWriteService);

}
