/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fryske_akademy.jsf;

/*-
 * #%L
 * guiCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
import java.util.List;
import javax.faces.bean.SessionScoped;
import org.fryske_akademy.ejb.Auditing;
import org.fryske_akademy.jpa.AbstractEntity;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jsf.util.JsfUtil;
import org.hibernate.envers.RevisionType;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;

/**
 *
 * @author eduard
 */
@SessionScoped
public abstract class AbstractEntityController<T extends AbstractEntity, S extends Auditing> extends AbstractController<S> {

    private T selected;
    private T newEntity;
    protected final Class<T> clazz;
    
    private boolean rememberTableState = true;

    /**
     * keep sorting and filtering (@multiViewState)
     *
     * @return
     */
    public boolean isRememberTableState() {
        return rememberTableState;
    }

    public void setRememberTableState(boolean rememberTableState) {
        this.rememberTableState = rememberTableState;
    }

    public AbstractEntityController(Class<T> clazz) {
        this.clazz = clazz;
    }

    public T getSelected() {
        return selected;
    }

    public void setSelected(T selected) {
        this.selected = selected;
    }

    public T getNewEntity() {
        return newEntity;
    }

    public void setNewEntity(T newEntity) {
        this.newEntity = newEntity;
    }

    public void onRowSelect(SelectEvent event) {
        if (event != null) {
            setSelected((T) event.getObject());
        }
    }

    /**
     * creates a new entity and calls {@link #fillNew(org.fryske_akademy.standertwurdlist.jpa.AbstractEntity)
     * }
     *
     * @throws InstantiationException
     * @throws IllegalAccessException
     */
    public final void prepareCreate() throws InstantiationException, IllegalAccessException {
        newEntity = clazz.newInstance();
        fillNew(newEntity);
    }

    /**
     * calls {@link #persist(org.fryske_akademy.standertwurdlist.jpa.AbstractEntity, org.fryske_akademy.standertwurdlist.jsf.util.JsfUtil.PersistAction, java.lang.String)
     * }
     * and {@link #gotoPageContaining(org.fryske_akademy.standertwurdlist.jpa.AbstractEntity)
     * }
     */
    public T create() {
        T persisted = persist(newEntity, JsfUtil.PersistAction.CREATE, JsfUtil.getLocaleBundle("/Bundle").getString("Created"));
        if (!JsfUtil.isValidationFailed()) {
            gotoPageContaining(persisted);
        }
        return persisted;
    }

    public abstract Filtering<T> getFiltering();

    /**
     * Navigate (i.e. in a datatable) to the page containing the argument entity. Implementors can call {@link Filtering#select(java.lang.String, java.lang.String, int)
     * }.
     *
     * @param entity
     */
    protected abstract void gotoPageContaining(T entity);

    /**
     * implementors can fill the new object with values from selected
     *
     * @param newEntity
     * @param selected
     */
    protected abstract void fillCopy(T newEntity, T selected);

    /**
     * empty method, called from {@link #prepareCreate() }
     *
     * @param entity
     */
    protected void fillNew(T entity) {
    }

    /**
     * copy an entity, call {@link #fillCopy(org.fryske_akademy.jpa.AbstractEntity, org.fryske_akademy.jpa.AbstractEntity)
     * }
     *
     * @throws InstantiationException
     * @throws IllegalAccessException
     */
    public final void copy() throws InstantiationException, IllegalAccessException {
        if (selected != null) {
            T l = clazz.newInstance();
            fillCopy(l, getSelected());
            newEntity = l;
        }
    }

    /**
     * Call {@link #persist(org.fryske_akademy.standertwurdlist.jpa.AbstractEntity, org.fryske_akademy.standertwurdlist.jsf.util.JsfUtil.PersistAction, java.lang.String)
     * }
     *
     * @param editEvent
     */
    public void update(RowEditEvent editEvent) {
        persist((T) editEvent.getObject(), JsfUtil.PersistAction.UPDATE, JsfUtil.getLocaleBundle("/Bundle").getString("Updated"));
    }

    public void destroy() {
        persist(selected, JsfUtil.PersistAction.DELETE, JsfUtil.getLocaleBundle("/Bundle").getString("Deleted"));
        if (!JsfUtil.isValidationFailed()) {
            selected = null; // Remove selection
        }
    }

    /**
     * returns username, revision date and {@link RevisionType} for the last
     * revision found
     *
     * @see Auditing#getRevisionInfo(java.io.Serializable, java.lang.Integer,
     * java.lang.Class)
     * @param entity
     * @return
     */
    public String getLastChangedInfo(T entity) {
        List<RevInfo<T>> revisions = getCrudWriteService().getRevisionInfo(entity.getId(), 1, clazz);
        if (revisions.isEmpty()) {
            return "no changes";
        }
        RevInfo<T> rev = revisions.get(0);
        return rev.getRevisionInfo().getUsername() + " at " + rev.getRevisionInfo().getRevisionDate() + " (" + rev.getType() + ")";
    }

    public List<RevInfo<T>> getLastChanged(T entity, int max) {
        return getCrudWriteService().getRevisionInfo(entity, max, clazz);
    }

}
