/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.Serializable;
import java.util.List;
import javax.faces.bean.SessionScoped;
import org.fryske_akademy.ejb.Auditing;
import org.fryske_akademy.jpa.AbstractEntity;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jsf.AbstractController;
import org.fryske_akademy.jsf.Filtering;
import org.fryske_akademy.jsf.util.JsfUtil;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;

@SessionScoped
public abstract class AbstractEntityController<T extends AbstractEntity, S extends Auditing>
extends AbstractController<S> {
    private T selected;
    private T newEntity;
    protected final Class<T> clazz;
    private boolean rememberTableState = true;

    public boolean isRememberTableState() {
        return this.rememberTableState;
    }

    public void setRememberTableState(boolean rememberTableState) {
        this.rememberTableState = rememberTableState;
    }

    public AbstractEntityController(Class<T> clazz) {
        this.clazz = clazz;
    }

    public T getSelected() {
        return this.selected;
    }

    public void setSelected(T selected) {
        this.selected = selected;
    }

    public T getNewEntity() {
        return this.newEntity;
    }

    public void setNewEntity(T newEntity) {
        this.newEntity = newEntity;
    }

    public void onRowSelect(SelectEvent event) {
        if (event != null) {
            this.setSelected((AbstractEntity)event.getObject());
        }
    }

    public final void prepareCreate() throws InstantiationException, IllegalAccessException {
        this.newEntity = (AbstractEntity)this.clazz.newInstance();
        this.fillNew(this.newEntity);
    }

    public T create() {
        T persisted = this.persist(this.newEntity, JsfUtil.PersistAction.CREATE, JsfUtil.getLocaleBundle("/Bundle").getString("Created"));
        if (!JsfUtil.isValidationFailed()) {
            this.gotoPageContaining(persisted);
        }
        return persisted;
    }

    public abstract Filtering<T> getFiltering();

    protected abstract void gotoPageContaining(T var1);

    protected abstract void fillCopy(T var1, T var2);

    protected void fillNew(T entity) {
    }

    public final void copy() throws InstantiationException, IllegalAccessException {
        if (this.selected != null) {
            AbstractEntity l = (AbstractEntity)this.clazz.newInstance();
            this.fillCopy(l, this.getSelected());
            this.newEntity = l;
        }
    }

    public void update(RowEditEvent editEvent) {
        this.persist((AbstractEntity)editEvent.getObject(), JsfUtil.PersistAction.UPDATE, JsfUtil.getLocaleBundle("/Bundle").getString("Updated"));
    }

    public void destroy() {
        this.persist(this.selected, JsfUtil.PersistAction.DELETE, JsfUtil.getLocaleBundle("/Bundle").getString("Deleted"));
        if (!JsfUtil.isValidationFailed()) {
            this.selected = null;
        }
    }

    public String getLastChangedInfo(T entity) {
        List revisions = ((Auditing)this.getCrudWriteService()).getRevisionInfo((Serializable)entity.getId(), Integer.valueOf(1), this.clazz);
        if (revisions.isEmpty()) {
            return "no changes";
        }
        RevInfo rev = (RevInfo)revisions.get(0);
        return rev.getRevisionInfo().getUsername() + " at " + rev.getRevisionInfo().getRevisionDate() + " (" + rev.getType() + ")";
    }

    public List<RevInfo<T>> getLastChanged(T entity, int max) {
        return ((Auditing)this.getCrudWriteService()).getRevisionInfo(entity, Integer.valueOf(max), this.clazz);
    }
}

