/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fryske_akademy.jsf;

/*-
 * #%L
 * guiCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.List;
import javax.faces.bean.SessionScoped;
import org.fryske_akademy.ejb.Auditing;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.Param;
import org.fryske_akademy.jpa.AbstractEntity;
import org.fryske_akademy.jsf.lazy.AbstractLazyModel;

/**
 * baseclass for controllers supporting lazy loading, selecting, copying, crud and navigation. Filtering support is
 * in {@link AbstractLazyModel}.
 * @author eduard
 */
@SessionScoped
public abstract class AbstractLazyController<T extends AbstractEntity, S extends Auditing, R extends AbstractLazyModel<T>> extends AbstractEntityController<T,S> {

    private boolean useOr;
    
    private boolean syntaxInvalue = true;

    public AbstractLazyController(Class<T> clazz) {
        super(clazz);
    }


    /**
     * subclasses should have a @ManagedProperty for a {@link AbstractLazyModel}.
     * @return 
     */
    public abstract R getLazyModel();

    /**
     * subclasses should have a @ManagedProperty for a {@link AbstractLazyModel}.
     */
    public abstract void setLazyModel(R model);

    @Override
    public Filtering<T> getFiltering() {
        return getLazyModel();
    }
    /**
     * implement this to auto complete user input, see {@link CrudReadService#find(java.lang.String, java.util.List, java.lang.Integer, java.lang.Integer, java.lang.Class) }
     * @param query
     * @return 
     */
    public abstract List<String> complete(String query);

    /**
     * when true use or when several parameters are given
     * @see Param#getAndOr()
     * @return 
     */
    public boolean isUseOr() {
        return useOr;
    }

    public void setUseOr(boolean useOr) {
        this.useOr = useOr;
    }

    /**
     * when true support syntax in parameter value
     * @see Param.Builder
     * @return 
     */
    public boolean isSyntaxInvalue() {
        return syntaxInvalue;
    }

    public void setSyntaxInvalue(boolean syntaxInvalue) {
        this.syntaxInvalue = syntaxInvalue;
    }

}
