/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.util.List;
import java.util.logging.Logger;
import javax.faces.bean.SessionScoped;
import javax.faces.model.DataModel;
import org.fryske_akademy.ejb.Auditing;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jsf.AbstractController;
import org.fryske_akademy.jsf.Filtering;
import org.fryske_akademy.jsf.util.JsfUtil;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;

@SessionScoped
public abstract class AbstractEntityController<T extends EntityInterface, S extends Auditing>
extends AbstractController<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractEntityController.class.getName());
    private T selected;
    private T newEntity;
    protected final Class<T> clazz;
    private boolean rememberTableState = true;
    public static final String DEFAULT_BUNDLE_NAME = "/Bundle";

    public boolean isRememberTableState() {
        return this.rememberTableState;
    }

    public void setRememberTableState(boolean rememberTableState) {
        this.rememberTableState = rememberTableState;
    }

    public AbstractEntityController(Class<T> clazz) {
        this.clazz = clazz;
    }

    public T getSelected() {
        return this.selected;
    }

    public void setSelected(T selected) {
        this.selected = selected;
    }

    public T getNewEntity() {
        return this.newEntity;
    }

    public void setNewEntity(T newEntity) {
        this.newEntity = newEntity;
    }

    public void onRowSelect(SelectEvent event) {
        if (event != null) {
            this.setSelected((EntityInterface)event.getObject());
        }
    }

    public final void prepareCreate() throws InstantiationException, IllegalAccessException {
        this.newEntity = (EntityInterface)this.clazz.newInstance();
        this.fillNew(this.newEntity);
    }

    public T create() {
        T persisted = this.persist(this.newEntity, JsfUtil.PersistAction.CREATE, JsfUtil.getLocaleBundle(this.getBundleName()).getString("Created"));
        if (!JsfUtil.isValidationFailed()) {
            this.gotoPageContaining(persisted);
        }
        return persisted;
    }

    protected String getBundleName() {
        return DEFAULT_BUNDLE_NAME;
    }

    public abstract Filtering<T> getFiltering();

    protected abstract void gotoPageContaining(T var1);

    protected abstract void fillCopy(T var1, T var2);

    protected void fillNew(T entity) {
    }

    public final void copy() throws InstantiationException, IllegalAccessException {
        if (this.selected != null) {
            EntityInterface l = (EntityInterface)this.clazz.newInstance();
            this.fillCopy(l, this.getSelected());
            this.newEntity = l;
        }
    }

    public T update(RowEditEvent editEvent) {
        EntityInterface t = this.persist((EntityInterface)editEvent.getObject(), JsfUtil.PersistAction.UPDATE, JsfUtil.getLocaleBundle(this.getBundleName()).getString("Updated"));
        this.refreshRow(editEvent, t, true);
        return (T)t;
    }

    protected void refreshRow(RowEditEvent editEvent, T t, boolean update) {
        if (editEvent.getComponent() instanceof DataTable) {
            List rows;
            DataTable dt = (DataTable)editEvent.getComponent();
            Object value = dt.getValue();
            List list = rows = value instanceof List ? (List)value : null;
            if (value instanceof DataModel && ((DataModel)value).getWrappedData() instanceof List) {
                rows = (List)((DataModel)value).getWrappedData();
            }
            if (rows != null && dt.getRowIndex() > -1 && t.getId().equals(((EntityInterface)dt.getRowData()).getId())) {
                if (update) {
                    rows.set(dt.getRowIndex(), t);
                } else {
                    rows.set(dt.getRowIndex(), ((Auditing)this.getCrudWriteService()).find(((EntityInterface)dt.getRowData()).getId(), this.clazz));
                }
            } else {
                LOGGER.warning(String.format("Cannot refresh datatable row: %s", dt.getRowIndex()));
            }
        }
    }

    public void cancelRow(RowEditEvent editEvent) {
        this.refreshRow(editEvent, (EntityInterface)editEvent.getObject(), false);
    }

    public void destroy() {
        this.persist(this.selected, JsfUtil.PersistAction.DELETE, JsfUtil.getLocaleBundle(this.getBundleName()).getString("Deleted"));
        if (!JsfUtil.isValidationFailed()) {
            this.selected = null;
        }
    }

    public String getLastChangedInfo(T entity) {
        List revisions = ((Auditing)this.getCrudWriteService()).getRevisionInfo(entity.getId(), Integer.valueOf(1), this.clazz);
        if (revisions.isEmpty()) {
            return "no changes";
        }
        RevInfo rev = (RevInfo)revisions.get(0);
        return rev.getRevisionInfo().getUsername() + " at " + rev.getRevisionInfo().getRevisionDate() + " (" + rev.getType() + ")";
    }

    public List<RevInfo<T>> getLastChanged(T entity, int max) {
        return ((Auditing)this.getCrudWriteService()).getRevisionInfo(entity, Integer.valueOf(max), this.clazz);
    }
}

