/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf.lazy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.faces.bean.SessionScoped;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.Param;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jsf.AbstractLazyController;
import org.fryske_akademy.jsf.Filtering;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

@SessionScoped
public abstract class AbstractLazyModel<T extends EntityInterface>
extends LazyDataModel<T>
implements Filtering<T> {
    private final Class<T> clazz;
    private CrudReadService crudReadService;
    private boolean useOr;
    private boolean syntaxInvalue = true;
    private AbstractLazyController abstractLazyController;
    private final AtomicBoolean selecting = new AtomicBoolean();
    private final AtomicBoolean tableState = new AtomicBoolean();
    private final Map<String, Object> filters = new HashMap<String, Object>(3){

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                this.put(String.valueOf(key), null);
            }
            return super.get(key);
        }
    };
    private List<T> filtered;

    public AbstractLazyController getLazyController() {
        return this.abstractLazyController;
    }

    public final void setLazyController(AbstractLazyController lazyController) {
        if (this.abstractLazyController == null) {
            throw new IllegalStateException("lazy controller already wired");
        }
        this.abstractLazyController = lazyController;
        this.crudReadService = lazyController.getCrudWriteService();
    }

    public AbstractLazyModel(Class<T> clazz) {
        this.clazz = clazz;
    }

    public final CrudReadService getCrudReadService() {
        if (this.crudReadService == null) {
            throw new IllegalStateException("Please inject crudReadService via setLazyController()");
        }
        return this.crudReadService;
    }

    public T getRowData(String rowKey) {
        return (T)((EntityInterface)this.crudReadService.find((Serializable)Integer.valueOf(rowKey), this.clazz));
    }

    protected void init() {
        List<T> load = this.load(0, this.getPageSize(), null, null, null);
        this.setWrappedData(load);
        this.setRowCount(this.crudReadService.countDynamic(null, this.clazz));
    }

    protected Param.Builder initParamBuilder() {
        return new Param.Builder(this.isSyntaxInvalue(), Param.Builder.DEFAULT_MAPPING);
    }

    protected final List<Param> convertFilters(Map<String, Object> filters) {
        if (filters == null) {
            return null;
        }
        Param.Builder builder = this.initParamBuilder();
        for (Map.Entry<String, Object> p : filters.entrySet()) {
            this.addToParamBuilder(builder, p.getKey(), p.getValue());
        }
        return builder.build();
    }

    protected void addToParamBuilder(Param.Builder builder, String key, Object value) {
        if (!(value instanceof Boolean) || ((Boolean)value).booleanValue()) {
            builder.add(key, value, this.isUseOr());
        }
    }

    public final List<T> load(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        ArrayList<SortMeta> s = new ArrayList<SortMeta>(1);
        s.add(new SortMeta(null, sortField, sortOrder, null));
        return this.load(first, pageSize, s, filters);
    }

    public final List<T> load(int first, int pageSize, List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        CrudReadService.SORTORDER.Builder sortBuilder = new CrudReadService.SORTORDER.Builder();
        if (multiSortMeta != null) {
            multiSortMeta.forEach(h -> sortBuilder.add(h.getSortField(), AbstractLazyModel.convert(h.getSortOrder())));
        }
        List<Param> convertFilters = this.convertFilters(filters);
        List load = this.crudReadService.findDynamic(Integer.valueOf(first), Integer.valueOf(pageSize), sortBuilder.build(), convertFilters, this.clazz);
        this.setWrappedData(load);
        this.setRowCount(this.crudReadService.countDynamic(convertFilters, this.clazz));
        if (this.selecting.getAndSet(false)) {
            this.abstractLazyController.setRememberTableState(this.tableState.get());
        }
        return load;
    }

    public static CrudReadService.SORTORDER convert(SortOrder order) {
        if (order == null) {
            return null;
        }
        switch (order) {
            case ASCENDING: {
                return CrudReadService.SORTORDER.ASC;
            }
        }
        return CrudReadService.SORTORDER.DESC;
    }

    @Override
    public List<T> getFiltered() {
        return this.filtered;
    }

    @Override
    public void setFiltered(List<T> filtered) {
        this.filtered = filtered;
    }

    @Override
    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public final void select(String key, String value) {
        this.clear().add(key, value);
        if (!this.selecting.get()) {
            this.tableState.set(this.abstractLazyController.isRememberTableState());
        }
        this.abstractLazyController.setRememberTableState(false);
        this.selecting.set(true);
    }

    @Override
    public Filtering<T> add(String key, Object value) {
        this.filters.put(key, value);
        return this;
    }

    @Override
    public Filtering<T> clear() {
        this.filters.clear();
        return this;
    }

    public void setSyntaxInvalue(boolean syntaxInvalue) {
        this.syntaxInvalue = syntaxInvalue;
    }

    public boolean isUseOr() {
        return this.useOr;
    }

    public void setUseOr(boolean useOr) {
        this.useOr = useOr;
    }

    public boolean isSyntaxInvalue() {
        return this.syntaxInvalue;
    }
}

