/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;

public class SessionTimeoutListener
implements PhaseListener {
    private static final Logger LOGGER = Logger.getLogger(SessionTimeoutListener.class.getName());
    public static final String LOGINPATH = "/login.xhtml";

    protected String getLoginPath() {
        return LOGINPATH;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (!facesContext.getPartialViewContext().isAjaxRequest() || facesContext.getRenderResponse()) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(facesContext.getExternalContext().getRequest());
        if (request.getDispatcherType() == DispatcherType.FORWARD && this.getLoginPath().equals(request.getServletPath())) {
            String redirect = facesContext.getExternalContext().getRequestContextPath() + request.getServletPath();
            try {
                facesContext.getExternalContext().redirect(redirect);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "unable to redirect", e);
            }
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

