/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf.util;

import java.security.Principal;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.fryske_akademy.Util;

public class JsfUtil {
    private static final Logger LOGGER = Logger.getLogger(JsfUtil.class.getName());
    private static final ResourceBundle rootBundle = ResourceBundle.getBundle("EMPTY", Locale.ROOT);

    public static void handleException(Exception ex, String prefix) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, prefix, ex);
        }
        FacesContext.getCurrentInstance().validationFailed();
        JsfUtil.addErrorMessage(prefix + JsfUtil.deepestCause(ex).getLocalizedMessage());
    }

    public static SelectItem[] getSelectItems(List entities, boolean selectOne) {
        int size = selectOne ? entities.size() + 1 : entities.size();
        SelectItem[] items = new SelectItem[size];
        int i = 0;
        if (selectOne) {
            items[i++] = new SelectItem((Object)"", "---");
        }
        for (Object x : entities) {
            items[i++] = new SelectItem(x, x.toString());
        }
        return items;
    }

    public static boolean isValidationFailed() {
        return FacesContext.getCurrentInstance().isValidationFailed();
    }

    public static void addErrorMessage(Exception ex, String defaultMsg) {
        String msg = ex.getLocalizedMessage();
        if (msg != null && msg.length() > 0) {
            JsfUtil.addErrorMessage(msg);
        } else {
            JsfUtil.addErrorMessage(defaultMsg);
        }
    }

    public static void addErrorMessages(List<String> messages) {
        for (String message : messages) {
            JsfUtil.addErrorMessage(message);
        }
    }

    public static void addErrorMessage(String msg) {
        String cid = null;
        JsfUtil.addErrorMessage(cid, msg);
    }

    public static void addErrorMessage(String clientId, String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMsg);
    }

    public static void addSuccessMessage(String msg) {
        JsfUtil.addSuccessMessage("successInfo", msg);
    }

    public static void addSuccessMessage(String clientId, String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMsg);
    }

    public static String getRequestParameter(String key) {
        return (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(key);
    }

    public static Object getObjectFromRequestParameter(String requestParameterName, Converter converter, UIComponent component) {
        String theId = JsfUtil.getRequestParameter(requestParameterName);
        return converter.getAsObject(FacesContext.getCurrentInstance(), component, theId);
    }

    public static <T> T findInContext(Class<T> clazz) {
        return JsfUtil.findInContext(Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1), clazz);
    }

    public static <T> T findInContext(String name, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().getELResolver().getValue(facesContext.getELContext(), null, (Object)name);
    }

    public static <T> T findOrCreateInContext(String name, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().evaluateExpressionGet(facesContext, name, clazz);
    }

    public static <T extends Converter> void registerConverter(String id, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getApplication().addConverter(id, clazz.getName());
    }

    public static <T extends Converter> T getConverter(String id, Class<T> clazz) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().createConverter(id);
    }

    public static String fullServletPath() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
    }

    public static String contextPath() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        return externalContext.getRequestContextPath();
    }

    @Deprecated
    public static String split(String toSplit, int index) {
        return Util.split((String)toSplit, (int)index);
    }

    @Deprecated
    public static String split(String toSplit, int index, boolean ignorePatternAfterIndex) {
        return Util.split((String)toSplit, (int)index, (boolean)ignorePatternAfterIndex);
    }

    @Deprecated
    public static String split(String toSplit, String regex, int index, boolean ignorePatternAfterIndex) {
        return Util.split((String)toSplit, (String)regex, (int)index, (boolean)ignorePatternAfterIndex);
    }

    public static Throwable deepestCause(Throwable t) {
        if (t.getCause() != null) {
            return JsfUtil.deepestCause(t.getCause());
        }
        return t;
    }

    public static Principal findPrinciple() {
        return FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
    }

    public static void logout() throws ServletException {
        FacesContext.getCurrentInstance().getExternalContext().invalidateSession();
        ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).logout();
    }

    public static ResourceBundle getLocaleBundle(String bundle) {
        Locale loc = FacesContext.getCurrentInstance() != null ? FacesContext.getCurrentInstance().getViewRoot().getLocale() : Locale.getDefault();
        try {
            return ResourceBundle.getBundle(bundle, loc);
        }
        catch (MissingResourceException e) {
            LOGGER.warning("resource not found: " + bundle + ", returning EMPTY");
            return rootBundle;
        }
    }

    public static boolean mayEdit() {
        return FacesContext.getCurrentInstance().getExternalContext().isUserInRole("editor");
    }

    public static boolean mayEdit(String role) {
        return FacesContext.getCurrentInstance().getExternalContext().isUserInRole(role);
    }

    public static enum PersistAction {
        CREATE,
        DELETE,
        UPDATE;

    }
}

