/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.io.Serializable;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import javax.security.enterprise.SecurityContext;
import org.fryske_akademy.ejb.CrudWriteService;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jsf.util.JsfUtil;

public abstract class AbstractController<S extends CrudWriteService>
implements Serializable {
    private S crudWriteService;
    public static final String FACESREDIRECTTRUE = "?faces-redirect=true";
    @Inject
    private SecurityContext securityContext;

    public final S getCrudWriteService() {
        if (this.crudWriteService == null) {
            throw new IllegalStateException("Please inject crudWriteService via initCrudWriteService() and a call to setCrudWriteService()");
        }
        return this.crudWriteService;
    }

    protected <T extends EntityInterface> T persist(T edited, JsfUtil.PersistAction persistAction) {
        return this.persist(edited, persistAction, (Object)((Object)persistAction) + " success");
    }

    protected <T extends EntityInterface> T persist(T edited, JsfUtil.PersistAction persistAction, String successMessage) {
        return this.persist(edited, persistAction, successMessage, false);
    }

    protected <T extends EntityInterface> T persist(T edited, JsfUtil.PersistAction persistAction, String successMessage, boolean rethrow) {
        if (edited != null) {
            Converter converter = JsfUtil.getConverter(edited.getClass());
            try {
                switch (persistAction) {
                    case CREATE: {
                        edited = (EntityInterface)this.crudWriteService.create(edited);
                        break;
                    }
                    case UPDATE: {
                        edited = (EntityInterface)this.crudWriteService.update(edited);
                        break;
                    }
                    case DELETE: {
                        this.crudWriteService.delete(edited);
                    }
                }
                JsfUtil.addSuccessMessage(successMessage + " " + (converter != null ? converter.getAsString(null, null, edited) : edited));
            }
            catch (Exception ex) {
                if (rethrow) {
                    throw ex;
                }
                JsfUtil.handleException(ex, (Object)((Object)persistAction) + " " + (converter != null ? converter.getAsString(null, null, edited) : edited) + " failed: ");
            }
        }
        return edited;
    }

    public String diacriticsKeyBoard() {
        return "\u00e0\u00e1\u00e4\u00e2\u00c0\u00c1\u00c2\u00c4\u00e5\u00c5-back,\u00e8\u00e9\u00eb\u00ea\u00c8\u00c9\u00ca\u00cb-clear,\u00ec\u00ed\u00ef\u00ee\u00cc\u00cd\u00ce\u00cf-close,\u00f2\u00f3\u00f6\u00f4\u00d2\u00d3\u00d4\u00d6,\u00f9\u00fa\u00fc\u00fb\u00d9\u00da\u00db\u00dc,*?";
    }

    protected final void setCrudWriteService(S crudWriteService) {
        this.crudWriteService = crudWriteService;
    }

    protected abstract void initCrudWriteService(S var1);

    protected SecurityContext getSecurityContext() {
        return this.securityContext;
    }
}

