/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fryske_akademy.jsf;

/*-
 * #%L
 * guiCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
import java.util.List;
import javax.annotation.PostConstruct;
import org.fryske_akademy.ejb.Auditing;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.jpa.Param;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jsf.lazy.AbstractLazyModel;
import org.fryske_akademy.jsf.util.JsfUtil;

/**
 * baseclass for controllers supporting lazy loading, selecting, copying, crud
 * and navigation. Filtering support is in {@link AbstractLazyModel}. This class takes care of the necessary setup of the {@link AbstractLazyModel} provided in the constructor.
 *
 * @author eduard
 */
public abstract class AbstractLazyController<E extends EntityInterface, A extends Auditing, M extends AbstractLazyModel<E>> extends AbstractEntityController<E, A> {

    private final M lazyModel;

    /**
     * call this constructor from subclasses using the entity class and a lookup
     * of the related AbstractLazyModel managedBean
     *
     * @see JsfUtil#findInContext(java.lang.String, java.lang.Class)
     * @param clazz
     * @param lazyModel
     */
    public AbstractLazyController(Class<E> clazz, M lazyModel) {
        super(clazz);
        this.lazyModel = lazyModel;
    }

    @PostConstruct
    private void wiring() {
        lazyModel.setLazyController(this);
    }

    public M getLazyModel() {
        return lazyModel;
    }

    @Override
    public Filtering<E> getFiltering() {
        return lazyModel;
    }

    /**
     * implement this to auto complete user input, see {@link CrudReadService#find(java.lang.String, java.util.List, java.lang.Integer, java.lang.Integer, java.lang.Class)
     * }
     *
     * @param query
     * @return
     */
    public abstract List<String> complete(String query);

    /**
     * when true use or when several parameters are given
     *
     * @see Param#getAndOr()
     * @return
     */
    public boolean isUseOr() {
        return lazyModel.isUseOr();
    }

    public void setUseOr(boolean useOr) {
        lazyModel.setUseOr(useOr);
    }

    /**
     * when true support syntax in parameter value
     *
     * @see Param.Builder
     * @return
     */
    public boolean isSyntaxInvalue() {
        return lazyModel.isSyntaxInvalue();
    }

    public void setSyntaxInvalue(boolean syntaxInvalue) {
        lazyModel.setSyntaxInvalue(syntaxInvalue);
    }

}
