/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jsf;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.model.DataModel;
import org.fryske_akademy.ejb.Auditing;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jsf.AbstractController;
import org.fryske_akademy.jsf.Filtering;
import org.fryske_akademy.jsf.util.JsfUtil;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;

public abstract class AbstractEntityController<E extends EntityInterface, A extends Auditing>
extends AbstractController<A> {
    private static final Logger LOGGER = Logger.getLogger(AbstractEntityController.class.getName());
    private E selected;
    private E newEntity;
    protected final Class<E> clazz;
    private boolean rememberTableState = true;
    public static final String DEFAULT_BUNDLE_NAME = "/Bundle";
    protected static final String STATE = "state";
    protected static final String FILTERING = "filtering";

    public boolean isRememberTableState() {
        return this.rememberTableState;
    }

    public void setRememberTableState(boolean rememberTableState) {
        this.rememberTableState = rememberTableState;
    }

    public AbstractEntityController(Class<E> clazz) {
        this.clazz = clazz;
    }

    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E selected) {
        this.selected = selected;
    }

    public E getNewEntity() {
        return this.newEntity;
    }

    public void setNewEntity(E newEntity) {
        this.newEntity = newEntity;
    }

    public void onRowSelect(SelectEvent event) {
        if (event != null) {
            this.setSelected((EntityInterface)event.getObject());
        }
    }

    public void prepareCreate() throws InstantiationException, IllegalAccessException {
        this.newEntity = (EntityInterface)this.clazz.newInstance();
        this.fillNew(this.newEntity);
    }

    public E create() throws Exception {
        return this.create(this.newEntity);
    }

    public E create(E e) throws Exception {
        return this.persist(e, AbstractController.PersistAction.CREATE, JsfUtil.getFromBundle(JsfUtil.getLocaleBundle(this.getBundleName()), "Created"));
    }

    public E create(RowEditEvent event) throws Exception {
        EntityInterface e = this.create((EntityInterface)event.getObject());
        this.refreshRow(event, e, true);
        return (E)e;
    }

    protected String getBundleName() {
        return DEFAULT_BUNDLE_NAME;
    }

    public abstract Filtering<E> getFiltering();

    public Object getFilterValue(String key) {
        return this.getFiltering().getFilters().get(key);
    }

    public String getFilterString(String key) {
        Object value = this.getFiltering().getFilters().get(key);
        return value == null ? null : String.valueOf(value);
    }

    public Map<String, Object> getFilters(String key) {
        return this.getFiltering().getFilters();
    }

    public abstract String gotoPageContaining(E var1);

    protected abstract void fillCopy(E var1, E var2);

    protected void fillNew(E entity) {
    }

    public void copy() throws InstantiationException, IllegalAccessException {
        if (this.selected != null) {
            EntityInterface l = (EntityInterface)this.clazz.newInstance();
            this.fillCopy(l, this.getSelected());
            this.newEntity = l;
        }
    }

    public E update(RowEditEvent editEvent) throws Exception {
        EntityInterface t = this.persist((EntityInterface)editEvent.getObject(), AbstractController.PersistAction.UPDATE, JsfUtil.getFromBundle(JsfUtil.getLocaleBundle(this.getBundleName()), "Updated"));
        this.refreshRow(editEvent, t, true);
        return (E)t;
    }

    public E save(RowEditEvent event) throws Exception {
        EntityInterface t = (EntityInterface)event.getObject();
        return t.isTransient() ? this.create(event) : this.update(event);
    }

    protected void refreshRow(RowEditEvent editEvent, EntityInterface e, boolean update) {
        if (editEvent.getComponent() instanceof DataTable && e != null && e.getId() != null) {
            List rows;
            DataTable dt = (DataTable)editEvent.getComponent();
            Object value = dt.getValue();
            List list = rows = value instanceof List ? (List)value : null;
            if (value instanceof DataModel && ((DataModel)value).getWrappedData() instanceof List) {
                rows = (List)((DataModel)value).getWrappedData();
            }
            if (rows != null && dt.getRowIndex() > -1) {
                int rowIndex;
                int n = rowIndex = value instanceof DataModel ? ((DataModel)value).getRowIndex() : dt.getRowIndex();
                if (update) {
                    rows.set(rowIndex, e);
                } else {
                    rows.set(rowIndex, ((Auditing)this.getCrudWriteService()).find(((EntityInterface)dt.getRowData()).getId(), this.clazz));
                }
            } else {
                LOGGER.warning(String.format("Cannot refresh datatable row: %s", dt.getRowIndex()));
            }
        } else {
            LOGGER.warning(String.format("Cannot refresh datatable row for: %s", e));
        }
    }

    public void cancelRow(RowEditEvent editEvent) {
        this.refreshRow(editEvent, (EntityInterface)editEvent.getObject(), false);
    }

    public void destroy() throws Exception {
        this.destroy(this.selected);
        this.selected = null;
    }

    public void destroy(E e) throws Exception {
        this.persist(e, AbstractController.PersistAction.DELETE, JsfUtil.getFromBundle(JsfUtil.getLocaleBundle(this.getBundleName()), "Deleted"));
    }

    public String getLastChangedInfo(E entity) {
        List revisions = ((Auditing)this.getCrudWriteService()).getRevisionInfo(entity.getId(), Integer.valueOf(1), this.clazz);
        if (revisions.isEmpty()) {
            return "no changes";
        }
        RevInfo rev = (RevInfo)revisions.get(0);
        return rev.getRevisionInfo().getUsername() + " at " + rev.getRevisionInfo().getRevisionDate() + " (" + rev.getType() + ")";
    }

    public List<RevInfo<E>> getLastChanged(E entity, int max) {
        return ((Auditing)this.getCrudWriteService()).getRevisionInfo(entity, Integer.valueOf(max), this.clazz);
    }

    protected String filterAndRedirect(AbstractEntityController controller, String key, String value, String action) {
        controller.getFiltering().clear().add(key, value);
        return action + "?faces-redirect=true" + "&" + STATE + "=" + FILTERING;
    }
}

