/*
 * Copyright 2018 Fryske Akademy.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * This package contains interfaces and base classes for the development of crud (EJB/CDI) beans. The goal is
 * to provide support for dynamic queries, named queries, lazy loading, write operations (including batch) and
 * at the same time deal with intricacies of EntityManager and Transactions. The preferred usage is Local Stateless session bean injected in CDI controller beans.
 * The controller beans may be passivation capable, in that case a field holding a reference to a stateless session bean should be transient and a private method
 * readObject should initialize it, see Util#getBean.
 * Read and write operations are completely separated in the interfaces, which allows for optimization
 * and extra security. EJB is required for declarative security to work.
 */
package org.fryske_akademy.services;
