package org.fryske_akademy.jpa;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import java.time.LocalDateTime;

/**
 * class to enable LocalDateTime based querying of auditing information.
 * Accompanying postgres view, of course you may as well add a timestamp column that will be filled from
 * your RevisionListener.
 * <pre>
 create view timeview as
    select id, username,
    (to_timestamp('01-01-1970 00:00:00', 'DD-MM-YYYY HH24:MI:SS') + timestamp * interval '1 millisecond') at time zone 'cest' at time zone 'utc'
 as timestamp from revisioninfo;

 create index revuser on revisioninfo(username);
 create index revtime on revisioninfo(timestamp);
</pre>
 */
@NamedQuery(name = TimeView.USERS,
        query = "select distinct(t.username) from TimeView t"
)
@Entity
public class TimeView implements EntityInterface {
    public static final String USERS = "users";
    @Id
    @Column
    private Integer id;
    @Column
    private String username;

    @Column
    private LocalDateTime timestamp;

    @Override
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public LocalDateTime getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public String toString() {
        return "TimeWindow{" +
                "id=" + id +
                ", username='" + username + '\'' +
                ", timestamp=" + timestamp +
                '}';
    }
}
