/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.validation.lex0;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import name.dmaus.schxslt.Result;
import name.dmaus.schxslt.SchematronException;
import org.fryske_akademy.validation.ValidationException;
import org.fryske_akademy.validation.lex0.Lex0_SchematronHelper;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Lex0_ValidationHelper {
    public static final String CLASSPATH_URI_DICTIONARY_XSD = "classpath:/xsd/lex0/TEILex0.xsd";
    private static final Schema schema;

    public static Schema getSchema() {
        return schema;
    }

    public static void validateXml(InputStream xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(Reader xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(URL xml) throws SAXException, IOException {
        Lex0_ValidationHelper.validateXml(xml.openStream());
    }

    public static void validateXsdSchematron(URL xml) throws IOException, SchematronException, SAXException {
        Lex0_ValidationHelper.validateXml(xml);
        Lex0_ValidationHelper.validateSchematron(xml);
    }

    public static void validateSchematron(URL xml) throws IOException, SchematronException {
        Result result = Lex0_SchematronHelper.validate(xml);
        if (!result.isValid()) {
            throw new ValidationException(result.getValidationMessages().toString());
        }
    }

    public static void validateXsdSchematron(String xml) throws Exception {
        Lex0_ValidationHelper.validateXml(xml);
        Lex0_ValidationHelper.validateSchematron(xml);
    }

    public static void validateSchematron(String xml) throws SchematronException {
        Result result = Lex0_SchematronHelper.validate(xml);
        if (!result.isValid()) {
            throw new ValidationException(result.getValidationMessages().toString());
        }
    }

    public static void validateXml(String xml) throws SAXException, IOException {
        Lex0_ValidationHelper.validateXml(new StringReader(xml));
    }

    public static void main(String[] args) throws IOException, SAXException {
        if (args != null && args.length > 0) {
            File f = new File(args[0]);
            if (f.isFile()) {
                Lex0_ValidationHelper.validateXml(new URL(args[0]));
            } else if (f.isDirectory()) {
                Files.walk(f.toPath(), new FileVisitOption[0]).filter(p -> p.toFile().isFile()).forEach(p -> {
                    try {
                        Lex0_ValidationHelper.validateXml(p.toFile().toURI().toURL());
                    }
                    catch (IOException | SAXException e) {
                        System.err.println(p.toFile().getPath() + " invalid");
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    static {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = sf.newSchema(new Source[]{new SAXSource(new InputSource(Lex0_ValidationHelper.class.getResourceAsStream(XSD.XML_XSD.getPathInJar()))), new SAXSource(new InputSource(Lex0_ValidationHelper.class.getResourceAsStream(XSD.DCR_XSD.getPathInJar()))), new SAXSource(new InputSource(Lex0_ValidationHelper.class.getResourceAsStream(XSD.DICTIONARIES_XSD.getPathInJar())))});
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static enum XSD {
        DCR_XSD("/xsd/lex0/dcr.xsd"),
        XML_XSD("/xsd/lex0/xml.xsd"),
        DICTIONARIES_XSD("/xsd/lex0/TEILex0.xsd");

        private final String xsd;
        private String content;

        private XSD(String xsd) {
            this.xsd = xsd;
        }

        public String getPathInJar() {
            return this.xsd;
        }

        public String getContent() throws IOException {
            if (this.content == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                InputStream in = Lex0_ValidationHelper.class.getResourceAsStream(this.xsd);
                int i = -1;
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
                this.content = out.toString();
            }
            return this.content;
        }
    }
}

