<?xml version="1.0" encoding="utf-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
   <title>ISO Schematron rules</title>
   <!-- This file generated 2021-04-21T19:50:26Z by 'extract-isosch.xsl'. -->
   <!-- ********************* -->
   <!-- namespaces, declared: -->
   <!-- ********************* -->
   <ns prefix="tei" uri="http://www.tei-c.org/ns/1.0"/>
   <ns prefix="xs" uri="http://www.w3.org/2001/XMLSchema"/>
   <ns prefix="rng" uri="http://relaxng.org/ns/structure/1.0"/>
   <!-- ********************* -->
   <!-- namespaces, implicit: -->
   <!-- ********************* -->
   <ns prefix="dcr" uri="http://www.isocat.org/ns/dcr"/>
   <!-- ************ -->
   <!-- constraints: -->
   <!-- ************ -->
   <pattern id="schematron-constraint-TEILex0-att.datable.w3c-att-datable-w3c-when-1">
      <rule context="tei:*[@when]">
         <report test="@notBefore|@notAfter|@from|@to" role="nonfatal">The @when attribute cannot be used with any other att.datable.w3c attributes.</report>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-att.datable.w3c-att-datable-w3c-from-2">
      <rule context="tei:*[@from]">
         <report test="@notBefore" role="nonfatal">The @from and @notBefore attributes cannot be used together.</report>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-att.datable.w3c-att-datable-w3c-to-3">
      <rule context="tei:*[@to]">
         <report test="@notAfter" role="nonfatal">The @to and @notAfter attributes cannot be used together.</report>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-att.datable-calendar-calendar-4">
      <rule context="tei:*[@calendar]">
         <assert test="string-length(.) gt 0"> @calendar indicates the system or calendar to
              which the date represented by the content of this element belongs, but this
              <name/> element has no textual content.</assert>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-att.typed-subtypeTyped-5">
      <rule context="tei:*[@subtype]">
         <assert test="@type">The <name/> element should not be categorized in detail with @subtype unless also categorized in general with @type</assert>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-att.pointing-targetLang-targetLang-6">
      <rule context="tei:*[not(self::tei:schemaSpec)][@targetLang]">
         <assert test="@target">@targetLang should only be used on <name/> if @target is specified.</assert>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-att.spanning-spanTo-spanTo-2-7">
      <rule context="tei:*[@spanTo]">
         <assert test="id(substring(@spanTo,2)) and following::*[@xml:id=substring(current()/@spanTo,2)]">
The element indicated by @spanTo (<value-of select="@spanTo"/>) must follow the current element <name/>
         </assert>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-att.styleDef-schemeVersion-schemeVersionRequiresScheme-8">
      <rule context="tei:*[@schemeVersion]">
         <assert test="@scheme and not(@scheme = 'free')">
              @schemeVersion can only be used if @scheme is specified.
            </assert>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-p-abstractModel-structure-p-9">
      <rule context="tei:p">
         <report test="not(ancestor::tei:floatingText) and (ancestor::tei:p or ancestor::tei:ab)          and not(parent::tei:exemplum                |parent::tei:item                |parent::tei:note                |parent::tei:q                |parent::tei:quote                |parent::tei:remarks                |parent::tei:said                |parent::tei:sp                |parent::tei:stage                |parent::tei:cell                |parent::tei:figure                )">
        Abstract model violation: Paragraphs may not occur inside other paragraphs or ab elements.
      </report>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-p-abstractModel-structure-l-10">
      <rule context="tei:p">
         <report test="ancestor::tei:l[not(.//tei:note//tei:p[. = current()])]">
        Abstract model violation: Lines may not contain higher-level structural elements such as div, p, or ab.
      </report>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-ref-refAtts-11">
      <rule context="tei:ref">
         <report test="@target and @cRef">Only one of the
	attributes @target' and @cRef' may be supplied on <name/>
         </report>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-div-abstractModel-structure-l-14">
      <rule context="tei:div">
         <report test="ancestor::tei:l">
        Abstract model violation: Lines may not contain higher-level structural elements such as div.
      </report>
      </rule>
   </pattern>
   <pattern id="schematron-constraint-TEILex0-div-abstractModel-structure-p-15">
      <rule context="tei:div">
         <report test="ancestor::tei:p or ancestor::tei:ab and not(ancestor::tei:floatingText)">
        Abstract model violation: p and ab may not contain higher-level structural elements such as div.
      </report>
      </rule>
   </pattern>
   <!-- *********** -->
   <!-- deprecated: -->
   <!-- *********** -->
   <pattern>
      <rule context="tei:value">
         <report test="true()" role="nonfatal">
                  WARNING: use of deprecated element — The <name/> element will be removed from the TEI on 2022-02-15. 
                </report>
      </rule>
   </pattern>
   <pattern>
      <rule context="tei:unicodeName">
         <report test="true()" role="nonfatal">
                  WARNING: use of deprecated element — The <name/> element will be removed from the TEI on 2022-02-15. 
                </report>
      </rule>
   </pattern>
   <pattern>
      <rule context="tei:glyphName">
         <report test="true()" role="nonfatal">
                  WARNING: use of deprecated element — The <name/> element will be removed from the TEI on 2022-02-15. 
                </report>
      </rule>
   </pattern>
   <pattern>
      <rule context="tei:charProp">
         <report test="true()" role="nonfatal">
                  WARNING: use of deprecated element — The <name/> element will be removed from the TEI on 2022-02-15. 
                </report>
      </rule>
   </pattern>
   <pattern>
      <rule context="tei:charName">
         <report test="true()" role="nonfatal">
                  WARNING: use of deprecated element — The <name/> element will be removed from the TEI on 2022-02-15. 
                </report>
      </rule>
   </pattern>
</schema>
