/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.validation;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import name.dmaus.schxslt.Result;
import name.dmaus.schxslt.Schematron;
import name.dmaus.schxslt.SchematronException;
import org.fryske_akademy.validation.ValidationException;
import org.xml.sax.InputSource;

public class FA_SchematronHelper {
    public static final String TEI_DICTIONARIES_SCH = "/schematron/tei_dictionaries.sch";
    private static final Schematron SCHEMATRON;

    public static Result validate(URL xml) throws IOException, SchematronException {
        return SCHEMATRON.validate((Source)new SAXSource(new InputSource(xml.openStream())));
    }

    public static Result validate(String xml) throws SchematronException {
        return SCHEMATRON.validate((Source)new SAXSource(new InputSource(new StringReader(xml))));
    }

    public static void main(String[] args) throws IOException, SchematronException {
        if (args != null && args.length > 0) {
            File f = new File(args[0]);
            if (f.isFile()) {
                Result r = FA_SchematronHelper.validate(new URL(args[0]));
                if (!r.isValid()) {
                    System.err.println(f.getPath() + " invalid");
                    throw new ValidationException(r.getValidationMessages().toString());
                }
            } else if (f.isDirectory()) {
                Files.walk(f.toPath(), new FileVisitOption[0]).filter(p -> p.toFile().isFile()).forEach(p -> {
                    try {
                        Result r = FA_SchematronHelper.validate(new URL(args[0]));
                        if (!r.isValid()) {
                            System.err.println(p.toFile().getPath() + " invalid");
                            throw new ValidationException(r.getValidationMessages().toString());
                        }
                    }
                    catch (IOException | SchematronException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
        }
    }

    static {
        try {
            SCHEMATRON = new Schematron((Source)new SAXSource(new InputSource(FA_SchematronHelper.class.getResourceAsStream(TEI_DICTIONARIES_SCH))));
        }
        catch (SchematronException e) {
            throw new IllegalStateException("unable to initialize schematron", e);
        }
    }
}

