/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.transformation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import name.dmaus.schxslt.SchematronException;
import org.fryske_akademy.validation.lex0.Lex0_RngValidationHelper;
import org.xml.sax.SAXException;

public class XslTransformer {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private final Map<String, String> params = new HashMap<String, String>();
    private final Transformer transformer;
    private static final Map<String, Templates> TEMPLATES = new HashMap<String, Templates>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Transformer get(String id, StreamSource source, boolean newFactory) throws TransformerConfigurationException {
        boolean has = id != null && TEMPLATES.containsKey(id);
        Map<String, Templates> map = TEMPLATES;
        synchronized (map) {
            Templates t;
            if (has) {
                return TEMPLATES.get(id).newTransformer();
            }
            Templates templates = t = newFactory ? TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", XslTransformer.class.getClassLoader()).newTemplates(source) : FACTORY.newTemplates(source);
            if (id != null) {
                TEMPLATES.put(id, t);
            }
            return t.newTransformer();
        }
    }

    public XslTransformer(File stylesheet) throws TransformerConfigurationException, FileNotFoundException {
        this.transformer = XslTransformer.get(stylesheet.getAbsolutePath(), new StreamSource(stylesheet), false);
    }

    public XslTransformer(InputStream stylesheet, String id, boolean newFactory) throws TransformerConfigurationException {
        this.transformer = XslTransformer.get(id, new StreamSource(stylesheet), newFactory);
    }

    public XslTransformer(InputStream stylesheet, boolean newFactory) throws TransformerConfigurationException {
        this.transformer = XslTransformer.get(null, new StreamSource(stylesheet), newFactory);
    }

    public XslTransformer(Reader stylesheet, boolean newFactory) throws TransformerConfigurationException {
        this.transformer = XslTransformer.get(null, new StreamSource(stylesheet), newFactory);
    }

    public XslTransformer(String stylesheet) throws TransformerConfigurationException {
        this.transformer = XslTransformer.get(stylesheet, new StreamSource(stylesheet), false);
    }

    public XslTransformer(String stylesheet, Reader sheet) throws TransformerConfigurationException {
        this.transformer = XslTransformer.get(stylesheet, new StreamSource(sheet), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transform(String source) throws TransformerException {
        StreamSource ssSource = new StreamSource(new StringReader(source));
        StringWriter result = new StringWriter();
        StreamResult streamResult = new StreamResult(result);
        Transformer transformer = this.transformer;
        synchronized (transformer) {
            for (Map.Entry<String, String> e : this.params.entrySet()) {
                this.transformer.setParameter(e.getKey(), e.getValue());
            }
            this.transformer.transform(ssSource, streamResult);
            this.transformer.reset();
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <W extends Writer> W streamTransform(Reader source, W result) throws TransformerException {
        StreamSource ssSource = new StreamSource(source);
        StreamResult streamResult = new StreamResult(result);
        Transformer transformer = this.transformer;
        synchronized (transformer) {
            for (Map.Entry<String, String> e : this.params.entrySet()) {
                this.transformer.setParameter(e.getKey(), e.getValue());
            }
            this.transformer.transform(ssSource, streamResult);
            this.transformer.reset();
        }
        return result;
    }

    public void addParameter(String key, String value) {
        this.params.put(key, value);
    }

    public void clearParameters() {
        this.params.clear();
    }

    public static void clear() {
        TEMPLATES.clear();
    }

    public static void clear(String id) {
        TEMPLATES.remove(id);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.transformer.setErrorListener(errorListener);
    }

    public static void FaToLex0(String xml, Writer writer, boolean validate) throws TransformerException, IOException, SchematronException, SAXException {
        XslTransformer.FaToLex0(new StringReader(xml), writer, validate);
    }

    public static void FaToLex0(Reader reader, Writer writer, boolean validate) throws TransformerException, IOException, SchematronException, SAXException {
        XslTransformer transformer = new XslTransformer("src/main/resources/xslt/teiToLex0.xslt");
        Writer w = validate ? new TeeWriter(writer) : writer;
        transformer.streamTransform(reader, w);
        if (validate) {
            Lex0_RngValidationHelper.validateRngSchematron(((TeeWriter)w).sw.toString());
        }
    }

    private static class TeeWriter
    extends Writer {
        private final StringWriter sw;
        private final Writer writer;

        public TeeWriter(Writer writer) {
            this.writer = writer;
            this.sw = writer instanceof StringWriter ? (StringWriter)writer : new StringWriter();
        }

        @Override
        public void write(char[] chars, int i, int i1) throws IOException {
            this.writer.write(chars, i, i1);
            if (!(this.writer instanceof StringWriter)) {
                this.sw.write(chars, i, i1);
            }
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
            if (!(this.writer instanceof StringWriter)) {
                this.sw.flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            if (!(this.writer instanceof StringWriter)) {
                this.sw.close();
            }
        }
    }
}

