/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.validation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import name.dmaus.schxslt.Result;
import name.dmaus.schxslt.SchematronException;
import org.fryske_akademy.validation.FA_SchematronHelper;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FA_RngValidationHelper {
    private static final Schema schema;

    public static Schema getSchema() {
        return schema;
    }

    public static void validateXml(InputStream xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(Reader xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(URL xml) throws SAXException, IOException {
        FA_RngValidationHelper.validateXml(xml.openStream());
    }

    public static void validateRngSchematron(URL xml) throws Exception {
        FA_RngValidationHelper.validateXml(xml);
        FA_RngValidationHelper.validateSchematron(xml);
    }

    public static void validateSchematron(URL xml) throws IOException, SchematronException {
        Result result = FA_SchematronHelper.validate(xml);
        if (!result.isValid()) {
            throw new SchematronException(result.getValidationMessages().toString());
        }
    }

    public static void validateRngSchematron(String xml) throws IOException, SAXException, SchematronException {
        FA_RngValidationHelper.validateXml(xml);
        FA_RngValidationHelper.validateSchematron(xml);
    }

    public static void validateSchematron(String xml) throws SchematronException {
        Result result = FA_SchematronHelper.validate(xml);
        if (!result.isValid()) {
            throw new SchematronException(result.getValidationMessages().toString());
        }
    }

    public static void validateXml(String xml) throws SAXException, IOException {
        FA_RngValidationHelper.validateXml(new StringReader(xml));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args == null || args.length <= 0) throw new IllegalArgumentException("provide file or directory argument");
        File f = new File(args[0]);
        if (f.isFile()) {
            FA_RngValidationHelper.validateRngSchematron(f.toURI().toURL());
            return;
        } else {
            if (!f.isDirectory()) throw new IllegalArgumentException("not valid: " + args[0]);
            Files.walk(f.toPath(), new FileVisitOption[0]).filter(p -> p.toFile().isFile()).forEach(p -> {
                try {
                    FA_RngValidationHelper.validateRngSchematron(p.toFile().toURI().toURL());
                }
                catch (Exception e) {
                    System.err.println(p.toFile().getPath() + " invalid");
                    throw new RuntimeException(e);
                }
            });
        }
    }

    static {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0", "com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory", FA_RngValidationHelper.class.getClassLoader());
            schema = sf.newSchema(new Source[]{new SAXSource(new InputSource(FA_RngValidationHelper.class.getResourceAsStream(RNG.DICTIONARIES_RNG.getPathInJar())))});
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static enum RNG {
        DICTIONARIES_RNG("/rng/tei_dictionaries.rng");

        private final String rng;
        private String content;

        private RNG(String rng) {
            this.rng = rng;
        }

        public String getPathInJar() {
            return this.rng;
        }

        public String getContent() throws IOException {
            if (this.content == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                InputStream in = FA_RngValidationHelper.class.getResourceAsStream(this.rng);
                int i = -1;
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
                this.content = out.toString();
            }
            return this.content;
        }
    }
}

