/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.pos_tagger;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class WrappedRConnection
extends RConnection {
    public static final String OUTPUT_R_VAR_NAME = "annotated";
    public static final String LOAD_ERRORS = "loaderrors";
    private final File output;
    private final File loadErrors;

    public WrappedRConnection(String udpipeModel, String loadScript) throws RserveException {
        try {
            this.output = File.createTempFile(OUTPUT_R_VAR_NAME, "txt");
            this.loadErrors = File.createTempFile(LOAD_ERRORS, "log");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.assign("udmodel", udpipeModel);
        this.assign(LOAD_ERRORS, this.loadErrors.getPath());
        try {
            this.eval("source(\"" + loadScript + "\")");
        }
        catch (RserveException e) {
            try {
                throw new RserveException((RConnection)this, "Load failed: " + new String(Files.readAllBytes(this.loadErrors.toPath())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.output.deleteOnExit();
        this.assign(OUTPUT_R_VAR_NAME, this.output.getPath());
    }

    public boolean deleteOutput() {
        return this.output.delete();
    }

    public File initOutput() throws IOException {
        this.output.createNewFile();
        return this.output;
    }
}

