/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.pos_tagger;

import com.vectorprint.configuration.cdi.Property;
import java.io.File;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.fryske_akademy.pos_tagger.RconnectionFactory;
import org.fryske_akademy.pos_tagger.WrappedRConnection;

@ApplicationScoped
public class RConnectionPool {
    public static final String STARTRSERVE = "R CMD Rserve --no-save --slave";
    public static final String DEFAULTUDPIPEMODEL = "/opt/model.udpipe";
    public static final String LOAD_R = "load.R";
    private static final Logger LOGGER = Logger.getLogger(RConnectionPool.class.getName());
    @Inject
    @Property(defaultValue={"/bin/sh", "-c", "R CMD Rserve --no-save --slave"})
    private String[] startRserve;
    @Inject
    @Property(defaultValue={"3"})
    private int poolSize;
    @Inject
    @Property(defaultValue={"-1"})
    private int poolTimeoutMillis;
    @Inject
    @Property(defaultValue={"/opt/model.udpipe"})
    private String udpipeModel;
    @Context
    private ServletContext servletContext;
    private final GenericObjectPoolConfig<WrappedRConnection> config = new GenericObjectPoolConfig();
    private ObjectPool<WrappedRConnection> rConnectionObjectPool;

    public String getUdpipeModel() {
        return this.udpipeModel;
    }

    @PostConstruct
    private void init() {
        try {
            String scriptDir = this.servletContext.getRealPath("/resources");
            new ProcessBuilder(this.startRserve).start().waitFor();
            this.config.setMaxTotal(this.poolSize);
            this.config.setMaxIdle(this.poolSize);
            this.config.setMaxWait(Duration.ofMillis(this.poolTimeoutMillis));
            this.rConnectionObjectPool = new GenericObjectPool((PooledObjectFactory)new RconnectionFactory(scriptDir + File.separator + LOAD_R, this.udpipeModel), this.config);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "error loading", ex);
            throw new IllegalStateException(ex);
        }
    }

    @PreDestroy
    private void stop() {
        try {
            ((WrappedRConnection)this.rConnectionObjectPool.borrowObject()).shutdown();
        }
        catch (Exception e) {
            throw new IllegalStateException("shutdown Rserve failed", e);
        }
    }

    public WrappedRConnection borrow() throws Exception {
        return (WrappedRConnection)this.rConnectionObjectPool.borrowObject();
    }

    public void putBack(WrappedRConnection rConnection) throws Exception {
        this.rConnectionObjectPool.returnObject((Object)rConnection);
    }
}

