/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.pos_tagger;

import com.vectorprint.configuration.cdi.Property;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.servlet.ServletContext;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.fryske_akademy.pos_tagger.RConnectionPool;
import org.fryske_akademy.pos_tagger.UDPipePostTagService;
import org.fryske_akademy.pos_tagger.WrappedRConnection;
import org.rosuda.REngine.Rserve.RserveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ApplicationScoped
@Path(value="process")
public class UDPipePostTagService {
    public static final String ROOT = "process";
    public static final String TSVPATH = "tsv";
    public static final String CONLLUPATH = "conllu";
    public static final String INFOPATH = "info";
    private static final Logger LOGGER = LoggerFactory.getLogger(UDPipePostTagService.class);
    public static final String SCRIPTDIR = "/resources";
    private static final String SERVICE_R = "service.R";
    private static final int MAX = 2048000;
    @Context
    private ServletContext servletContext;
    @Inject
    @Property
    private String languageCode;
    @Inject
    private RConnectionPool rConnectionPool;
    private static final Properties BUILDPROPERTIES = new Properties();

    private File annotate(String text, FORMAT format) throws Exception {
        String scriptDir = this.servletContext.getRealPath("/resources");
        WrappedRConnection rConnection = this.rConnectionPool.borrow();
        try {
            File tempFile = new File(UUID.randomUUID().toString());
            File annotated = rConnection.initOutput();
            try {
                rConnection.assign("output", format.name().toLowerCase(Locale.ROOT));
                rConnection.assign("text", text);
                rConnection.eval("source(\"" + scriptDir + File.separator + "service.R\")");
                Files.move(annotated.toPath(), tempFile.toPath(), new CopyOption[0]);
                File file = tempFile;
                return file;
            }
            catch (IOException | RserveException ex) {
                tempFile.delete();
                throw ex;
            }
        }
        finally {
            this.rConnectionPool.putBack(rConnection);
        }
    }

    @GET
    @Path(value="info")
    @Produces(value={"application/json"})
    public Response info() {
        JsonObject jsonObject = Json.createObjectBuilder().add("version", this.versionInfo()).add("languageCode", this.languageCode).add("udpipeModel", this.rConnectionPool.getUdpipeModel()).add("maxTextSize", 2048000).add("info", "//udpipe/process/info").add("tsv", "//udpipe/process/tsv").add("conllu", "//udpipe/process/conllu").build();
        return Response.ok((Object)jsonObject).build();
    }

    @POST
    @Path(value="tsv")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/tab-separated-values"})
    public Response tagTsv(@Size(min=0, max=2048000) @Size(min=0, max=2048000) String text) {
        return this.getResponse(text, FORMAT.TSV);
    }

    @POST
    @Path(value="conllu")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response tagConllu(@Size(min=0, max=2048000) @Size(min=0, max=2048000) String text) {
        return this.getResponse(text, FORMAT.CONLLU);
    }

    private Response getResponse(String text, FORMAT format) {
        try {
            1 output = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)output).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable t = UDPipePostTagService.deepestCause((Throwable)ex);
            throw new WebApplicationException(Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)(t instanceof RserveException ? "Please retry" : t.getMessage())).build());
        }
    }

    public static Throwable deepestCause(Throwable t) {
        if (t.getCause() != null) {
            return UDPipePostTagService.deepestCause((Throwable)t.getCause());
        }
        return t;
    }

    public String versionInfo() {
        return BUILDPROPERTIES.toString();
    }

    static {
        try {
            BUILDPROPERTIES.load(UDPipePostTagService.class.getResourceAsStream("/build.properties"));
        }
        catch (IOException e) {
            LOGGER.warn("unable to load build properties", (Throwable)e);
        }
    }
}

